/**
 * PETALS - PETALS Services Platform.
 * Copyright (c) 2008 OW2 Consortium, http://www.ow2.org/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.easycommons.stream;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

import com.ebmwebsourcing.easycommons.lang.UncheckedException;

/**
 * @author aruffie This forker class allow to create on demand one copy of
 * original <InputStream> provided. Several copies can be recovered by
 * many calls to its, but take in account that original <InputStream>
 * provided will be consumed.
 * @see {@link InputStreamForker#fork()} function.
 */
public final class InputStreamForker {
    
    private static final int BUFFER_SIZE = 8192;
    
    private final byte[] bytes;
    
    public InputStreamForker(final InputStream originalInputStream) {
        bytes = readBytes(new BufferedInputStream(originalInputStream));
    }

    
    private static final byte[] readBytes(InputStream originalInputStream) {
        int n;
        final byte[] buffer = new byte[BUFFER_SIZE];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            while ((n = originalInputStream.read(buffer)) != -1) {
                baos.write(buffer, 0, n);
            }
        } catch (IOException e) {
            throw new UncheckedException(e);
        }
        return baos.toByteArray();
    }
    
    /**
     * This function allow to recover a new <InputStream> which contains one
     * copy of the original <InputStream>
     * 
     * @return Return one copy of the original <InputStream>
     * @throws <IOException>
     */
    public final InputStream fork() throws IOException {
        return new ByteArrayInputStream(bytes);
    }

    
    
    
}
