/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.soap.handler.test;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlContextFactory;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easybox.api.XmlObjectReader;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPException;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPMessageGenerator;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import java.net.URL;
import junit.framework.Assert;
import org.junit.Test;
import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Binding;
import org.petalslink.abslayer.service.api.Description;
import org.w3c.dom.Document;

public class SOAPMessageGeneratorTest {
    @Test
    public void testSOAPMessageGenerator() throws XmlObjectReadException, SOAPException {
        Description desc = this.readDescription(Thread.currentThread().getContextClassLoader().getResource("travelagency/travelagency.wsdl"));
        SOAPMessageGenerator soapMessage = new SOAPMessageGenerator(desc);
        Binding b = (Binding)desc.getBindings().iterator().next();
        Document request = soapMessage.generateSoapRequest(b.getOperationByName("process"));
        System.out.println(XMLPrettyPrinter.prettyPrint((Document)request));
        Assert.assertNotNull((Object)request);
        Document response = soapMessage.generateSoapResponse(b.getOperationByName("process"));
        System.out.println(XMLPrettyPrinter.prettyPrint((Document)response));
        Assert.assertNotNull((Object)response);
    }

    public Description readDescription(URL wsdlUrl) throws XmlObjectReadException {
        XmlContextFactory xmlContextFactory = new XmlContextFactory();
        XmlContext xmlContext = xmlContextFactory.newContext();
        XmlObjectReader reader = xmlContext.createReader();
        Definitions definitions = (Definitions)reader.readDocument(wsdlUrl, Definitions.class);
        return (Description)Factory.getInstance().wrap((XmlObject)definitions);
    }
}

