/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.soap.handler;

import com.ebmwebsourcing.easycommons.soap.handler.SOAPException;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.DOMBuilder;
import org.jdom.output.DOMOutputter;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SOAPSender {
    private final Logger log = Logger.getLogger(SOAPSender.class.getName());

    public org.w3c.dom.Document sendSoapRequest(org.w3c.dom.Document request, String address, String soapAction) throws SOAPException {
        org.w3c.dom.Document response = null;
        if (address == null) {
            throw new SOAPException("destination address cannot be null");
        }
        if (request == null) {
            throw new SOAPException("request message cannot be null");
        }
        SOAPConnectionFactory soapConnFactory = null;
        SOAPConnection connection = null;
        try {
            soapConnFactory = SOAPConnectionFactory.newInstance();
            connection = soapConnFactory.createConnection();
        }
        catch (UnsupportedOperationException e1) {
            throw new SOAPException(e1);
        }
        catch (javax.xml.soap.SOAPException e1) {
            throw new SOAPException(e1);
        }
        try {
            MessageFactory messageFactory = MessageFactory.newInstance();
            SOAPMessage message = messageFactory.createMessage();
            if (soapAction != null) {
                MimeHeaders hd = message.getMimeHeaders();
                hd.addHeader("SOAPAction", soapAction);
            }
            SOAPPart soapPart = message.getSOAPPart();
            SOAPEnvelope envelope = soapPart.getEnvelope();
            SOAPBody body = envelope.getBody();
            StreamSource preppedMsgSrc = new StreamSource(SOAPSender.convertDOMSource2InputSource(new DOMSource(request)).getByteStream());
            soapPart.setContent((Source)preppedMsgSrc);
            message.saveChanges();
            this.log.finest("\nREQUEST:\n");
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(out);
            message.writeTo((OutputStream)ps);
            this.log.finest(out.toString());
            String destination = address;
            this.log.finest("\ndestination = " + destination);
            this.log.finest("XXXXXX send message: " + out.toString());
            this.log.finest("XXXXXX destination: " + destination);
            this.log.finest("XXXXXX soapAction: " + soapAction);
            this.log.finest("XXXXXX message: " + XMLPrettyPrinter.prettyPrint((org.w3c.dom.Document)request));
            SOAPMessage reply = connection.call(message, (Object)destination);
            if (reply != null) {
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                Source sourceContent = reply.getSOAPPart().getContent();
                StringWriter writer = new StringWriter();
                StreamResult result = new StreamResult(writer);
                transformer.transform(sourceContent, result);
                String res = ((Object)writer).toString();
                this.log.finest("\nRESPONSE:\n" + res);
                DocumentBuilderFactory builder = DocumentBuilderFactory.newInstance();
                builder.setNamespaceAware(true);
                response = builder.newDocumentBuilder().parse(new ByteArrayInputStream(res.getBytes()));
            }
        }
        catch (UnsupportedOperationException e) {
            throw new SOAPException(e);
        }
        catch (javax.xml.soap.SOAPException e) {
            throw new SOAPException(e);
        }
        catch (TransformerConfigurationException e) {
            throw new SOAPException(e);
        }
        catch (TransformerException e) {
            throw new SOAPException(e);
        }
        catch (SAXException e) {
            throw new SOAPException(e);
        }
        catch (IOException e) {
            throw new SOAPException(e);
        }
        catch (ParserConfigurationException e) {
            throw new SOAPException(e);
        }
        finally {
            try {
                connection.close();
            }
            catch (javax.xml.soap.SOAPException e) {
                throw new SOAPException(e);
            }
        }
        return response;
    }

    public static org.w3c.dom.Document createSOAPMessageRequest(org.w3c.dom.Document msg) throws JDOMException {
        org.w3c.dom.Document res = null;
        Element env = new Element("Envelope", Namespace.getNamespace((String)"soap-env", (String)"http://schemas.xmlsoap.org/soap/envelope/"));
        env.addNamespaceDeclaration(Namespace.getNamespace((String)"xsd", (String)"http://www.w3.org/1999/XMLSchema"));
        env.addNamespaceDeclaration(Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/1999/XMLSchema-instance"));
        Document jdom = new Document(env);
        Element body = new Element("Body", Namespace.getNamespace((String)"soap-env", (String)"http://schemas.xmlsoap.org/soap/envelope/"));
        env.addContent((Content)body);
        DOMBuilder builder = new DOMBuilder();
        if (msg != null) {
            Document jdomDocument = builder.build(msg);
            body.addContent(((Element)jdomDocument.getRootElement().clone()).detach());
        }
        DOMOutputter converter = new DOMOutputter();
        res = converter.output(jdom);
        return res;
    }

    private static InputSource convertDOMSource2InputSource(DOMSource domSource) throws SOAPException {
        InputSource source = null;
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            StreamResult streamResult = new StreamResult(os);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(domSource, streamResult);
            os.flush();
            os.close();
            ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
            StreamSource attach = new StreamSource(is);
            source = SAXSource.sourceToInputSource(attach);
            ((InputStream)is).close();
        }
        catch (IOException e) {
            throw new SOAPException(e);
        }
        catch (TransformerConfigurationException e) {
            throw new SOAPException(e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new SOAPException(e);
        }
        catch (TransformerException e) {
            throw new SOAPException(e);
        }
        return source;
    }
}

