/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.ws.fireman.test;

import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easyesb.ws.fireman.test.NotifierThread;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Subscribe;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.TopicExpressionType;
import com.ebmwebsourcing.wsstar.jaxb.notification.base.GetCurrentMessage;
import com.ebmwebsourcing.wsstar.jaxb.notification.base.GetCurrentMessageResponse;
import com.ebmwebsourcing.wsstar.jaxb.notification.base.SubscribeResponse;
import com.ebmwebsourcing.wsstar.jaxb.notification.base.Unsubscribe;
import com.ebmwebsourcing.wsstar.jaxb.notification.base.UnsubscribeResponse;
import com.ebmwebsourcing.wsstar.jaxb.resource.resourceproperties.GetResourcePropertyResponse;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.Wsnb4ServUtils;
import com.petalslink.wsn.service.wsnproducer.NotificationProducer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.jws.WebService;
import javax.xml.namespace.QName;
import org.oasis_open.docs.wsn.bw_2.InvalidFilterFault;
import org.oasis_open.docs.wsn.bw_2.InvalidMessageContentExpressionFault;
import org.oasis_open.docs.wsn.bw_2.InvalidProducerPropertiesExpressionFault;
import org.oasis_open.docs.wsn.bw_2.InvalidTopicExpressionFault;
import org.oasis_open.docs.wsn.bw_2.MultipleTopicsSpecifiedFault;
import org.oasis_open.docs.wsn.bw_2.NoCurrentMessageOnTopicFault;
import org.oasis_open.docs.wsn.bw_2.NotifyMessageNotSupportedFault;
import org.oasis_open.docs.wsn.bw_2.SubscribeCreationFailedFault;
import org.oasis_open.docs.wsn.bw_2.TopicExpressionDialectUnknownFault;
import org.oasis_open.docs.wsn.bw_2.TopicNotSupportedFault;
import org.oasis_open.docs.wsn.bw_2.UnableToDestroySubscriptionFault;
import org.oasis_open.docs.wsn.bw_2.UnacceptableInitialTerminationTimeFault;
import org.oasis_open.docs.wsn.bw_2.UnrecognizedPolicyRequestFault;
import org.oasis_open.docs.wsn.bw_2.UnsupportedPolicyRequestFault;
import org.oasis_open.docs.wsrf.rpw_2.InvalidResourcePropertyQNameFault;
import org.oasis_open.docs.wsrf.rw_2.ResourceUnavailableFault;
import org.oasis_open.docs.wsrf.rw_2.ResourceUnknownFault;
import org.w3c.dom.Document;

@WebService(serviceName="FiremanEventProducer", portName="FiremanSOAPEventProducer", targetNamespace="http://www.soceda.org/crisis/v1/deliver_iodine/Fireman/", wsdlLocation="crisis/v1/deliver_iodine/Fireman.wsdl", endpointInterface="com.petalslink.wsn.service.wsnproducer.NotificationProducer")
public class NotificationProducerImpl
implements NotificationProducer {
    private static final Logger LOG = Logger.getLogger(NotificationProducerImpl.class.getName());
    private boolean notifier = false;

    @Override
    public GetCurrentMessageResponse getCurrentMessage(GetCurrentMessage getCurrentMessageRequest) throws TopicNotSupportedFault, InvalidTopicExpressionFault, ResourceUnknownFault, TopicExpressionDialectUnknownFault, NoCurrentMessageOnTopicFault, MultipleTopicsSpecifiedFault {
        LOG.info("Executing operation getCurrentMessage");
        System.out.println(getCurrentMessageRequest);
        try {
            GetCurrentMessageResponse _return = null;
            return _return;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    @Override
    public UnsubscribeResponse unsubscribe(Unsubscribe unsubscribeRequest) throws ResourceUnknownFault, UnableToDestroySubscriptionFault {
        LOG.info("Executing operation unsubscribe");
        System.out.println(unsubscribeRequest);
        try {
            UnsubscribeResponse _return = null;
            return _return;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    @Override
    public SubscribeResponse subscribe(com.ebmwebsourcing.wsstar.jaxb.notification.base.Subscribe subscribeRequest) throws NotifyMessageNotSupportedFault, TopicNotSupportedFault, InvalidFilterFault, InvalidTopicExpressionFault, ResourceUnknownFault, TopicExpressionDialectUnknownFault, UnrecognizedPolicyRequestFault, SubscribeCreationFailedFault, InvalidMessageContentExpressionFault, UnsupportedPolicyRequestFault, UnacceptableInitialTerminationTimeFault, InvalidProducerPropertiesExpressionFault {
        LOG.info("Executing operation subscribe");
        System.out.println(subscribeRequest);
        try {
            Document doc = SOAJAXBContext.getInstance().unmarshallAnyElement((Object)subscribeRequest);
            Subscribe subscribe = Wsnb4ServUtils.getWsnbReader().readSubscribe(doc);
            List<QName> topics = this.findTopics(subscribe);
            QName topic = null;
            if (topics != null && topics.size() > 0) {
                topic = topics.get(0);
            }
            String address = subscribe.getConsumerReference().getAddress().getValue().toString();
            if (this.isNotifier()) {
                NotifierThread notifier = new NotifierThread(this.getClass().getAnnotation(WebService.class).portName(), address, topic, "http://www.w3.org/TR/1999/REC-xpath-19991116", null);
                notifier.start();
            }
            SubscribeResponse _return = new SubscribeResponse();
            return _return;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    private List<QName> findTopics(Subscribe subscribe) {
        ArrayList<QName> topics = new ArrayList<QName>();
        for (TopicExpressionType topicExp : subscribe.getFilter().getTopicExpressions()) {
            String prefix = null;
            String lp = null;
            String ns = null;
            if (topicExp.getContent().contains(":")) {
                prefix = topicExp.getContent().split(":")[0];
                lp = topicExp.getContent().split(":")[1].replace(":", "");
            } else {
                lp = QName.valueOf(topicExp.getContent()).getLocalPart();
                ns = QName.valueOf(topicExp.getContent()).getNamespaceURI();
            }
            if (prefix != null) {
                for (QName name : topicExp.getTopicNamespaces()) {
                    if (!name.getPrefix().equals(prefix)) continue;
                    ns = name.getNamespaceURI();
                    break;
                }
            }
            QName topic = null;
            topic = ns != null ? new QName(ns, lp, prefix) : new QName(lp);
            topics.add(topic);
        }
        return topics;
    }

    @Override
    public GetResourcePropertyResponse getResourceProperty(QName getResourcePropertyRequest) throws ResourceUnknownFault, InvalidResourcePropertyQNameFault, ResourceUnavailableFault {
        LOG.info("Executing operation getResourceProperty");
        System.out.println(getResourcePropertyRequest);
        try {
            GetResourcePropertyResponse _return = new GetResourcePropertyResponse();
            Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(Thread.currentThread().getContextClassLoader().getResource("crisis/v1/deliver_iodine/FiremanTopicSet.xml").openStream());
            _return.getAny().add(doc.getDocumentElement());
            return _return;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    public void setNotifier(boolean notifier) {
        this.notifier = notifier;
    }

    public boolean isNotifier() {
        return this.notifier;
    }
}

