package com.ebmwebsourcing.easyesb.ws.fireman.test;
/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/


import com.ebmwebsourcing.easycommons.research.util.cxf.CXFHelper;
import com.ebmwebsourcing.easycommons.research.util.cxf.Server;


 
public class Fireman_NotificationProducer_Server{

	private Server ep;
	
    public Fireman_NotificationProducer_Server(String address) throws Exception {
        System.out.println("Starting Server");
        Object implementor = new NotificationProducerImpl();
        ep = CXFHelper.getService(address, implementor.getClass(), implementor);
        
    }
    
    public Fireman_NotificationProducer_Server(String address, boolean notifier) throws Exception {
        System.out.println("Starting Server");
        NotificationProducerImpl implementor = new NotificationProducerImpl();
        implementor.setNotifier(notifier);
        ep = CXFHelper.getService(address, implementor.getClass(), implementor);
        
    }
    
    
    
    public static void main(String args[]) throws Exception { 
        new Fireman_NotificationProducer_Server("http://localhost:9211/FiremanSOAPEventProducer");
       
        
//        Thread.sleep(5 * 60 * 1000); 
//        System.out.println("Server exiting");
//        System.exit(0);
    }
    
    public void start() {
    	ep.start();
        System.out.println("Server ready..."); 
	}

	public void stop() {
		ep.stop();
	}
}
