/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
/**
 * PETALS - PETALS Services Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.easyesb.launcher.tasks;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.component.Component;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ClientEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.Endpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.external.ExternalServer;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.service.Service;

/**
 * 
 * Created on 13 févr. 08
 * 
 * @author Christophe HAMERLING - eBM WebSourcing
 * @since
 * 
 */
public class InfoTask extends Task {


	private Node node = null;


	/**
	 * 
	 * @param node 
	 * @param petalsServer
	 */
	public InfoTask(Node node) {
		this.node = node;
		this.setShortcut("i");
		this.setName("info");
		this.setDescription("Display the local container information");

	}

	@Override
	public int doProcess(List<String> args) {
		try {
			System.out.println("Infos");
			if(node != null) {
				List<String> components = new ArrayList<String>();
				List<String> services = new ArrayList<String>();
				List<String> providerEndpoints = new ArrayList<String>();
				List<String> clientProxyEndpoints = new ArrayList<String>();
				for(Endpoint ep: ((RegistryEndpointBehaviour)this.node.getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).getLocalEndpoints()) {
					Object e = ep.getComponent().getFcInterface("service");
					if(e instanceof Component) {
						components.add(ep.getQName().toString());
					} else if(e instanceof Service) {
						services.add(ep.getQName().toString());
					} else if(e instanceof ProviderEndpoint) {
						providerEndpoints.add(ep.getQName().toString());
					} else if(e instanceof ClientEndpoint) {
						clientProxyEndpoints.add(ep.getQName().toString());
					} 
				}
				services.add(((Service)this.node.getRegistryEndpoint().getParent()).getQName().toString());
				providerEndpoints.add(this.node.getRegistryEndpoint().getQName().toString());

				System.out.println("\n\n\nLocal composition of node: " + this.node.getQName());
				System.out.println("--------------------------\n");

				int port = -1;
				for(ExternalServer server: ((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).getExternalServers()) {
					port = server.getPort();
					if(port != -1) {
						break;
					}
				}

				if(((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).getAdminExternalEndpoint() != null) {
					System.out.println("External administration service available at: \n\t" + ((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).getAdminExternalEndpoint());
				}


				System.out.println("\n\nListeners:\n");
				for(ExternalServer server: ((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).getExternalServers()) {
					System.out.println("\t- " + server.getName());
				}

				System.out.println("\n\nComponents:\n");
				for(String comp: components) {
					System.out.println("\t- " + comp);
				}

				System.out.println("\n\nServices:\n");
				for(String s: services) {
					System.out.println("\t- " + s);
				}

				System.out.println("\n\nProvider Endpoints:\n");
				for(String pep: providerEndpoints) {
					System.out.println("\t- " + pep);
				}
				System.out.println("\n\nClient Proxy Endpoints:\n");
				for(String cep: clientProxyEndpoints) {
					System.out.println("\t- " + cep);
				}
			} else {
				throw new ESBException("node cannot be null");
			}
		} catch (Exception e) {
			e.printStackTrace(System.err);
		}
		return OK_CODE;
	}

}
