/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.launcher;

import com.ebmwebsourcing.easyesb.launcher.Launcher;
import com.ebmwebsourcing.easyesb.launcher.util.CommandReader;
import com.ebmwebsourcing.easyesb.launcher.util.Locker;
import com.ebmwebsourcing.easyesb.launcher.util.SystemExitHook;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.factory.ESBCoreFactory;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.LogManager;
import javax.xml.namespace.QName;

public abstract class AbstractNodeLauncher
implements Launcher {
    private static final String START_COMMAND = "start";
    private static final String SHUTDOWN_COMMAND = "shutdown";
    private static final String VERSION_COMMAND = "version";
    protected ESBCoreFactory factory = null;
    private String banner = null;
    private static final String LOGGER_FILE = "/logger.properties";
    private Node server;
    private SystemExitHook systemExitHook;
    private final Locker locker;

    public AbstractNodeLauncher(ESBCoreFactory factory) throws ESBException {
        this.factory = factory;
        if (this.factory == null) {
            throw new ESBException("ESBCoreFactory parameter cannot be null!!!");
        }
        this.locker = new Locker(new File("."));
    }

    protected void showBanner() {
        System.out.println();
        System.out.println(this.getBanner());
        System.out.println();
    }

    public void setBanner(String banner) {
        this.banner = banner;
    }

    public String getBanner() {
        if (this.banner == null) {
            this.banner = " -----------------------------------------------------------\n|                                                           |\n|                          " + this.getDistributionName() + "                          |\n" + "|             EBM Research Enterprise Service Bus           |\n" + "|               http://research.petalslink.org              |\n" + "|                                                           |\n" + " -----------------------------------------------------------\n";
        }
        return this.banner;
    }

    public void launch(String[] args) {
        this.showBanner();
        ArrayList<String> command = new ArrayList<String>();
        boolean console = true;
        if (args.length == 0) {
            command.add(START_COMMAND);
        }
        for (String arg : args) {
            command.add(arg);
        }
        try {
            if (command.contains(SHUTDOWN_COMMAND)) {
                System.out.println(this.getDistributionName() + " is stopping...");
                this.shutdown();
            } else if (command.contains(VERSION_COMMAND)) {
                this.version();
            } else if (command.contains(START_COMMAND)) {
                System.out.println(this.getDistributionName() + " is starting...");
                this.start();
                if (console) {
                    this.commandLineMode(this.server);
                }
                if (this.systemExitHook != null) {
                    Runtime.getRuntime().removeShutdownHook(this.systemExitHook);
                }
                this.systemExitHook.run();
                System.exit(0);
            } else {
                System.out.println("Command '" + command + "' is unknown");
                this.printUsage();
                System.exit(-1);
            }
        }
        catch (Throwable e) {
            System.out.println("Command processing error : " + command);
            e.printStackTrace(System.err);
            if (this.systemExitHook != null) {
                Runtime.getRuntime().removeShutdownHook(this.systemExitHook);
            }
            System.exit(-1);
        }
    }

    @Override
    public void start() throws Exception {
        if (this.locker.isLocked()) {
            throw new ESBException("Can not start the " + this.getDistributionName() + ", remove lock file from root path or stop server");
        }
        this.locker.lock();
        this.server = this.getFactory().createNode(new QName("http://ow2.petals.org", "node0"), this.getFactory().getDefaultConfiguration());
        this.printStartedMessage();
        this.systemExitHook = new SystemExitHook(this.locker);
        Runtime.getRuntime().addShutdownHook(this.systemExitHook);
    }

    @Override
    public void shutdown() throws Exception {
        if (this.systemExitHook == null) {
            this.systemExitHook = new SystemExitHook(this.locker);
        }
        this.systemExitHook.start();
    }

    @Override
    public void version() throws Exception {
        System.out.println("No version");
    }

    protected void printUsage() {
        System.out.println("usage:");
        System.out.println(" -start                  start the " + this.getDistributionName());
        System.out.println(" -shutdowm               shutdown the " + this.getDistributionName());
        System.out.println(" -version                get the " + this.getDistributionName() + " version");
    }

    private void printStartedMessage() {
        this.printSpecificStartMessage();
        Date date = new Date(System.currentTimeMillis());
        SimpleDateFormat sdf = new SimpleDateFormat();
        System.out.println();
        System.out.println(this.getDistributionName() + " distribution successfully started - " + sdf.format(date));
    }

    protected void printSpecificStartMessage() {
    }

    protected void commandLineMode(Node node) throws Exception {
        CommandReader console = new CommandReader(node, this);
        console.read();
    }

    @Override
    public ESBCoreFactory getFactory() {
        return this.factory;
    }

    protected abstract String getDistributionName();

    public abstract String getShortName();

    static {
        try {
            InputStream inputStream = null;
            File logger = new File("./logger.properties");
            inputStream = logger.exists() ? new FileInputStream(logger) : AbstractNodeLauncher.class.getClass().getResourceAsStream(LOGGER_FILE);
            if (inputStream != null) {
                LogManager.getLogManager().readConfiguration(inputStream);
                inputStream.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("couldn't initialize logging properly", e);
        }
    }
}

