/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
/**
 * EasyESB: EasyESB Services Platform Copyright (C) 2009 EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 * 
 * Initial developer(s): EBM WebSourcing
 */
package com.ebmwebsourcing.easyesb.soa.api.config;

import java.util.List;
import java.util.Map;

import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.EndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.external.ExternalServer;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryService;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryServiceBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.service.Service;
import com.ebmwebsourcing.easyesb.soa.api.service.ServiceBehaviour;

/**
 * @author chamerling - eBM WebSourcing
 * 
 */
public interface Configuration {


	public static final String PORT = "port";
	public static final String DEFAULT_PORT = "9000";

	public static final String HOST = "host";
	public static final String DEFAULT_HOST = "localhost";

	public static final String EXPLORER = "explorer";
	public static final String DEFAULT_EXPLORER = "false";

	public static final String SOAP_EXTERNAL_PORT = "soap-external-port";
	public static final String COMMON_ENDPOINT_INITIALIZATION_INTERCEPTOR = "common-endpoint-initialization-interceptor";

	public static final String REGISTRY_SERVICE_CLASS = "registry-service-class";
	public static final String REGISTRY_SERVICE_BEHAVIOUR_CLASS = "registry-service-behaviour-class";

	public static final String ADMIN_SERVICE_CLASS = "admin-service-class";
	public static final String ADMIN_SERVICE_BEHAVIOUR_CLASS = "admin-service-behaviour-class";
	public static final String ADMIN_ENDPOINT_BEHAVIOUR_CLASS = "admin-endpoint-behaviour-class";
	
	public static final String RESOURCES_SERVICE_CLASS = "resources-service-class";
	public static final String RESOURCES_SERVICE_BEHAVIOUR_CLASS = "resources-service-behaviour-class";
	public static final String RESOURCES_ENDPOINT_BEHAVIOUR_CLASS = "resources-endpoint-behaviour-class";
	
	/**
	 * @return the data
	 */
	Map<String, String> getProperties();

	void addProperty(String key, String value);

	Integer getPort();

	void setPort(int port);

	String getHost();

	void setHost(String host);

	Boolean getExplorer();

	void setExplorer(boolean explorer);

	List<ExternalServer> getExternalServers();

	void addExternalServer(ExternalServer es);

	List<String> getEndpointInitializationInterceptorClassNames();

	void addEndpointInitializationInterceptorClassName(String eii);

	Class<? extends RegistryService> getRegistryServiceClass();

	void setRegistryServiceClass(Class<? extends RegistryService> clazz);

	Class<? extends RegistryServiceBehaviour> getRegistryServiceBehaviourClass();

	void setRegistryServiceBehaviourClass(Class<? extends RegistryServiceBehaviour> clazz);

	Class<? extends Service> getAdminServiceClass();

	// admin
	void setAdminServiceClass(Class<? extends Service> clazz);

	Class<? extends ServiceBehaviour> getAdminServiceBehaviourClass();

	void setAdminServiceBehaviourClass(Class<? extends ServiceBehaviour> clazz);

	Class<? extends EndpointBehaviour> getAdminEndpointBehaviourClass();

	void setAdminEndpointBehaviourClass(Class<? extends EndpointBehaviour> clazz);
	
	
	// resources
	Class<? extends Service> getResourcesServiceClass();

	void setResourcesServiceClass(Class<? extends Service> clazz);

	Class<? extends ServiceBehaviour> getResourcesServiceBehaviourClass();

	void setResourcesServiceBehaviourClass(Class<? extends ServiceBehaviour> clazz);

	Class<? extends EndpointBehaviour> getResourcesEndpointBehaviourClass();

	void setResourcesEndpointBehaviourClass(Class<? extends EndpointBehaviour> clazz);

}
