/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.soa.api.transport;

import java.util.Map;
import java.util.UUID;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyesb.transporter.api.transport.Transporter;
import com.ebmwebsourcing.easyesb.transporter.api.transport.lifecycle.LifeCycle;


/**
 * The <code>Transporter</code> is used to send a <code>MessageExchange</code>
 * from a container to another one. <br>
 * The local <code>Router</code> calls
 * <code>send(exchange,distantContainer)</code> on this <code>Transporter</code>
 * to send an exchange. <br>
 * This <code>Transporter</code> sends the <code>MessageExchange</code> to the
 * distant <code>Transporter</code>. <br>
 * When the distant <code>Transporter</code> receives the
 * <code>MessageExchange</code>, it has to call <code>receive(exchange)</code>
 * on its local <code>Router</code>. <br>
 * The localization of the distant container is in charge of the
 * <code>Transporter</code>. <br>
 * <br>
 * <em>Note that the destination container can be the same than this one.</em>
 * 
 * @version $Rev: 477 $ $Date: 2006-05-29 17:18:07 +0200 (lun., 29 mai 2006) $
 * @author nsalatge
 */
public interface TransportersManager extends Transporter, LifeCycle {
    
	void setQName(QName name);
	
	<T extends Transporter>  T createTransporter(String name, Class<T> clazz) throws ESBException;
    
	Map<UUID, WakeUpKey> getStub2awake();
	
	<T extends Transporter>  T getTransporter(Class<T> clazz);
	
	Node getNode();
	
	void setNode(Node node);
}
