/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.soa.impl.config;

import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.config.Configuration;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryService;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryServiceBehaviour;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConfigurationImpl
implements Configuration {
    private static Logger log = Logger.getLogger(ConfigurationImpl.class.getName());
    private Map<String, String> properties = new ConcurrentHashMap<String, String>();
    private static String CONFIG = "config.properties";
    private List<String> endpointInitializationInterceptors = new ArrayList<String>();
    private Class<? extends RegistryService> registryServiceClass;
    private Class<? extends RegistryServiceBehaviour> registryServiceBehaviourClass;

    public ConfigurationImpl() throws ESBException {
        this.properties.put("host", "localhost");
        this.properties.put("port", "9000");
        this.loadConfigurationFile();
    }

    public ConfigurationImpl(Map<String, String> data) throws ESBException {
        this.properties = data;
    }

    public ConfigurationImpl(String host, int port) throws ESBException {
        this.properties.put("host", String.valueOf(host));
        this.properties.put("port", String.valueOf(port));
    }

    public ConfigurationImpl(String host, int port, Map<String, String> otherproperties) throws ESBException {
        this.properties.put("host", String.valueOf(host));
        this.properties.put("port", String.valueOf(port));
        this.properties.putAll(otherproperties);
    }

    private void loadConfigurationFile() throws ESBException {
        Properties props = new Properties();
        File f = new File(CONFIG);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Loading config from " + f.getAbsoluteFile());
        }
        FileInputStream is = null;
        if (f.exists()) {
            try {
                is = new FileInputStream(f);
            }
            catch (FileNotFoundException e) {
                throw new ESBException((Throwable)e);
            }
        }
        if (is != null) {
            try {
                props.load(is);
                for (Object k : props.keySet()) {
                    if ("common-endpoint-initialization-interceptor".equals(k.toString().trim())) {
                        String interceptorClassName = props.get(k).toString().trim();
                        this.endpointInitializationInterceptors.add(interceptorClassName);
                        continue;
                    }
                    if ("registry-service-class".equals(k.toString().trim())) {
                        String registryServiceClassName = props.get(k).toString().trim();
                        Class<?> registryServiceClass = Thread.currentThread().getContextClassLoader().loadClass(registryServiceClassName);
                        this.setRegistryServiceClass(registryServiceClass);
                        continue;
                    }
                    if ("registry-service-behaviour-class".equals(k.toString().trim())) {
                        String registryServiceBehaviourClassName = props.get(k).toString().trim();
                        Class<?> registryServiceBehaviourClass = Thread.currentThread().getContextClassLoader().loadClass(registryServiceBehaviourClassName);
                        this.setRegistryServiceBehaviourClass(registryServiceBehaviourClass);
                        continue;
                    }
                    this.properties.put(k.toString().trim(), props.get(k).toString().trim());
                }
            }
            catch (IOException e) {
                throw new ESBException((Throwable)e);
            }
            catch (ClassNotFoundException e) {
                throw new ESBException((Throwable)e);
            }
        } else {
            log.warning("No configuration file found...");
        }
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void addProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public static String getCONFIG() {
        return CONFIG;
    }

    public static void setCONFIG(String config) {
        CONFIG = config;
    }

    public Integer getPort() {
        return Integer.valueOf(this.getProperties().get("port"));
    }

    public String getHost() {
        return String.valueOf(this.getProperties().get("host"));
    }

    public void setHost(String host) {
        this.properties.put("host", String.valueOf(host));
    }

    public void setPort(int port) {
        this.properties.put("port", String.valueOf(port));
    }

    public List<String> getEndpointInitializationInterceptorClassNames() {
        return this.endpointInitializationInterceptors;
    }

    public void addEndpointInitializationInterceptorClassName(String eii) {
        this.endpointInitializationInterceptors.add(eii);
    }

    public Class<? extends RegistryService> getRegistryServiceClass() {
        return this.registryServiceClass;
    }

    public void setRegistryServiceClass(Class<? extends RegistryService> clazz) {
        this.registryServiceClass = clazz;
    }

    public Class<? extends RegistryServiceBehaviour> getRegistryServiceBehaviourClass() {
        return this.registryServiceBehaviourClass;
    }

    public void setRegistryServiceBehaviourClass(Class<? extends RegistryServiceBehaviour> clazz) {
        this.registryServiceBehaviourClass = clazz;
    }
}

