/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.soa.impl.endpoint.behaviour.specific;

import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Binding;
import org.petalslink.abslayer.service.api.Description;
import org.w3c.dom.Document;

import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.ESBUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.EndpointAddress;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyesb.constant.EasyESBFramework;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.AbstractEndpointBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.specific.NotificationProducerEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.specific.SubscriptionManagerEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.util.MessageUtil;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.impl.impl.WsrfbfModelFactoryImpl;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Renew;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.RenewResponse;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Unsubscribe;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.UnsubscribeResponse;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.refinedabstraction.RefinedWsnbFactory;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.impl.WsnbModelFactoryImpl;
import com.ebmwebsourcing.wsstar.resource.datatypes.impl.impl.WsrfrModelFactoryImpl;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.impl.impl.WsrfrlModelFactoryImpl;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.impl.impl.WsrfrpModelFactoryImpl;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.abstraction.TopicNamespaceType;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.abstraction.TopicSetType;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.abstraction.TopicType;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.refinedabstraction.RefinedWstopFactory;
import com.ebmwebsourcing.wsstar.topics.datatypes.impl.impl.TopicTypeImpl;
import com.ebmwebsourcing.wsstar.topics.datatypes.impl.impl.WstopModelFactoryImpl;
import com.ebmwebsourcing.wsstar.wsnb.services.ISubscriptionManager;
import com.ebmwebsourcing.wsstar.wsnb.services.faults.InvalidFilterFault;
import com.ebmwebsourcing.wsstar.wsnb.services.faults.InvalidMessageContentExpressionFault;
import com.ebmwebsourcing.wsstar.wsnb.services.faults.InvalidProducerPropertiesExpressionFault;
import com.ebmwebsourcing.wsstar.wsnb.services.faults.InvalidTopicExpressionFault;
import com.ebmwebsourcing.wsstar.wsnb.services.faults.MultipleTopicsSpecifiedFault;
import com.ebmwebsourcing.wsstar.wsnb.services.faults.NoCurrentMessageOnTopicFault;
import com.ebmwebsourcing.wsstar.wsnb.services.faults.NotifyMessageNotSupportedFault;
import com.ebmwebsourcing.wsstar.wsnb.services.faults.SubscribeCreationFailedFault;
import com.ebmwebsourcing.wsstar.wsnb.services.faults.TopicExpressionDialectUnknownFault;
import com.ebmwebsourcing.wsstar.wsnb.services.faults.TopicNotSupportedFault;
import com.ebmwebsourcing.wsstar.wsnb.services.faults.UnableToDestroySubscriptionFault;
import com.ebmwebsourcing.wsstar.wsnb.services.faults.UnacceptableInitialTerminationTimeFault;
import com.ebmwebsourcing.wsstar.wsnb.services.faults.UnrecognizedPolicyRequestFault;
import com.ebmwebsourcing.wsstar.wsnb.services.faults.UnsupportedPolicyRequestFault;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.engines.NotificationProducerEngine;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.engines.SubscriptionManagerEngine;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.topic.TopicsManagerEngine;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.Wsnb4ServUtils;
import com.ebmwebsourcing.wsstar.wsrfbf.services.faults.AbsWSStarFault;
import com.ebmwebsourcing.wsstar.wsrfr.services.faults.ResourceUnknownFault;

public class SubscriptionManagerEndpointBehaviourImpl extends AbstractEndpointBehaviourImpl implements SubscriptionManagerEndpointBehaviour {


	private static Logger log = Logger.getLogger(SubscriptionManagerEndpointBehaviourImpl.class.getName());

	public static final String EBM_RESOURCEIDS_PREFIX = "ebm";
	public static final String EBM_RESOURCEIDS_NAMESPACE_URI = "http://petals.ow2.org/ebmwebsourcing/specific/ResourceIds";
	private static final String EBM_TOPICS_EXTENSION_NAMESPACE_URI = "http://org.ow2.petals/ebmwebsourcing/specific/topicExtension";
	public static final QName SUPPORTED_QNAME_ATTR = new QName(EBM_TOPICS_EXTENSION_NAMESPACE_URI, "supported", EBM_RESOURCEIDS_PREFIX);


	private SubscriptionManagerEngine subsMgrEngine = null;
	private TopicsManagerEngine topicsMgrEngine = null;

	private URL evenTopicNamespaceDefinitionUrl = null;

	private TopicSetType topicSet = null;
	private TopicNamespaceType topicNs = null;

	private static Binding b; 
	static {
		Wsnb4ServUtils.initModelFactories(
				new WsrfbfModelFactoryImpl(), 
				new WsrfrModelFactoryImpl(), 
				new WsrfrlModelFactoryImpl(), 
				new WsrfrpModelFactoryImpl(), 
				new WstopModelFactoryImpl(), new WsnbModelFactoryImpl());

		try {
			Description desc = (Description) Factory.getInstance().wrap(SOAUtil.getInstance().getReader(EasyESBFramework.getInstance()).get().readDocument(Thread.currentThread().getContextClassLoader().getResource(DESCRIPTION_URL), Definitions.class));
			Iterator<?> it = desc.getBindings().iterator();

			//this.setBinding(desc.findBinding(new QName("http://www.ebmwebsourcing.com/wsn/service/WsnProducer", "PausableSubscriptionManagerSOAPBinding")));
			//it.next();
			b = (Binding) it.next();
		} catch (XmlObjectReadException e) {
			e.printStackTrace();
			throw new RuntimeException();
		}
	}

	public SubscriptionManagerEndpointBehaviourImpl(
			final ProviderEndpoint<?> ep) {
		super(ep);

		this.setBinding(b);

	}

	private void initNotification() throws ESBException {
		try {

			if(evenTopicNamespaceDefinitionUrl != null && this.topicSet != null) {

				InputStream is = evenTopicNamespaceDefinitionUrl.openStream();
				Document docTopicNs = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(is);
				is.close();
				this.topicNs = RefinedWstopFactory.getInstance().getWstopReader().readTopicNamespaceType(docTopicNs);
			//	this.topicSet = this.createTopicSetFromTopicNamespace(topicNs, supportedTopics);

				final org.w3c.dom.Document topicSetDom = RefinedWstopFactory.getInstance().getWstopWriter().writeTopicSetTypeAsDOM(topicSet);


				this.topicsMgrEngine = new TopicsManagerEngine();
				this.subsMgrEngine = new SubscriptionManagerEngine(log);//, /*this.topicsMgrEngine,*/ this.persistenceMgr,notificationSender);

				// TODO: change by valid endpoint
				EndpointAddress epr = ESBUtil.analyzeURI(this.endpoint.getReference());
				this.subsMgrEngine.setSubscriptionsManagerEdp(epr.getEndpointname());
				this.subsMgrEngine.setSubscriptionsManagerInterface(this.getBinding().getInterface().getQName());
				this.subsMgrEngine.setSubscriptionsManagerService(new QName(epr.getNamespace(), epr.getServicename()));    	

				NotificationProducerEndpointBehaviour producerBehaviour = this.endpoint.findBehaviour(NotificationProducerEndpointBehaviourImpl.class);
				if(producerBehaviour != null) {

					NotificationProducerEngine notifProdEngine = 
						new NotificationProducerEngine(log, this.topicsMgrEngine, this.subsMgrEngine, true,
								topicSet, topicNs, "wsn", null /*this.notifSender*/);

					producerBehaviour.setNotificationProducer(notifProdEngine);
				}
				
				// add subscribers to node
				this.getEndpoint().getNode().findBehaviour(NodeBehaviour.class).getEndpointSubscribers().put(this.topicSet, this.getEndpoint());
			}
		} catch (Exception e) {
			throw new ESBException(e);
		} 
	}


	// ---------------------------------------------------------
	//   ------- "Helpers" for TopicTypeImpl type -----------
	// --------------------------------------------------------

	// ------ Getter ----------

	/**
	 * check if a given topic is a supported topic in the current context
	 *  
	 * @param topic {@link TopicType} object to check 
	 * @return true if supported , false if not
	 */
	public static Boolean isTopicSupported(TopicType topic) {
		Boolean res = null;
		com.ebmwebsourcing.wsstar.jaxb.notification.topics.TopicType model = TopicTypeImpl.toJaxbModel(topic);
		final String value = model.getOtherAttributes().get(SUPPORTED_QNAME_ATTR);
		if (value != null) {
			res = Boolean.valueOf(value);
		}
		return res;
	}


	public void execute(final Exchange exchange) throws TransportException  {
		try {
			log.finest("notification provider BEHAVIOUR FOUND: " + exchange.getOperation());
			log.finest("notification provider BEHAVIOUR FOUND: " + XMLPrettyPrinter.prettyPrint(exchange.getMessageIn().printMessage()));

			if (QName.valueOf(exchange.getOperation()).getLocalPart()
					.equals("Unsubscribe")
					&& (exchange.getMessageIn().getBody().getPayload() instanceof Document)) {

				log.finest("UN SUBSCRIBE");

				Unsubscribe subscribe = RefinedWsnbFactory.getInstance().getWsnbReader().readUnsubscribe(exchange.getMessageIn().getBody().getPayload());
				UnsubscribeResponse res = this.unsubscribe(subscribe);
				Document docResp = RefinedWsnbFactory.getInstance().getWsnbWriter().writeUnsubscribeResponseAsDOM(res);

				MessageUtil.getInstance().createOutMessageStructure(exchange);
				exchange.getMessageOut().getBody().setPayload(docResp);

			} 
		} catch (ResourceUnknownFault e) {
			log.severe("ERROR IN SubscriptionManagerEndpointBehaviour BEHAVIOUR: " + e.getMessage());
			throw new TransportException(e);
		} catch (UnableToDestroySubscriptionFault e) {
			log.severe("ERROR IN SubscriptionManagerEndpointBehaviour BEHAVIOUR: " + e.getMessage());
			throw new TransportException(e);
		} catch (TopicNotSupportedFault e) {
			log.severe("ERROR IN SubscriptionManagerEndpointBehaviour BEHAVIOUR: " + e.getMessage());
			throw new TransportException(e);
		} catch (InvalidTopicExpressionFault e) {
			log.severe("ERROR IN SubscriptionManagerEndpointBehaviour BEHAVIOUR: " + e.getMessage());
			throw new TransportException(e);
		} catch (UnrecognizedPolicyRequestFault e) {
			log.severe("ERROR IN SubscriptionManagerEndpointBehaviour BEHAVIOUR: " + e.getMessage());
			throw new TransportException(e);
		} catch (InvalidMessageContentExpressionFault e) {
			log.severe("ERROR IN SubscriptionManagerEndpointBehaviour BEHAVIOUR: " + e.getMessage());
			throw new TransportException(e);
		} catch (UnsupportedPolicyRequestFault e) {
			log.severe("ERROR IN SubscriptionManagerEndpointBehaviour BEHAVIOUR: " + e.getMessage());
			throw new TransportException(e);
		} catch (TopicExpressionDialectUnknownFault e) {
			e.printStackTrace();
			log.severe("ERROR IN SubscriptionManagerEndpointBehaviour BEHAVIOUR: " + e.getMessage());
			throw new TransportException(e);
		} catch (UnacceptableInitialTerminationTimeFault e) {
			log.severe("ERROR IN SubscriptionManagerEndpointBehaviour BEHAVIOUR: " + e.getMessage());
			throw new TransportException(e);
		} catch (InvalidProducerPropertiesExpressionFault e) {
			log.severe("ERROR IN SubscriptionManagerEndpointBehaviour BEHAVIOUR: " + e.getMessage());
			throw new TransportException(e);
		} catch (InvalidFilterFault e) {
			log.severe("ERROR IN SubscriptionManagerEndpointBehaviour BEHAVIOUR: " + e.getMessage());
			throw new TransportException(e);
		} catch (SubscribeCreationFailedFault e) {
			log.severe("ERROR IN SubscriptionManagerEndpointBehaviour BEHAVIOUR: " + e.getMessage());
			throw new TransportException(e);
		} catch (NotifyMessageNotSupportedFault e) {
			log.severe("ERROR IN SubscriptionManagerEndpointBehaviour BEHAVIOUR: " + e.getMessage());
			throw new TransportException(e);
		} catch (MultipleTopicsSpecifiedFault e) {
			log.severe("ERROR IN SubscriptionManagerEndpointBehaviour BEHAVIOUR: " + e.getMessage());
			throw new TransportException(e);
		} catch (NoCurrentMessageOnTopicFault e) {
			log.severe("ERROR IN SubscriptionManagerEndpointBehaviour BEHAVIOUR: " + e.getMessage());
			throw new TransportException(e);
		} catch (WsnbException e) {
			log.severe("ERROR IN SubscriptionManagerEndpointBehaviour BEHAVIOUR: " + e.getMessage());
			throw new TransportException(e);
		} catch (AbsWSStarFault e) {
			log.severe("ERROR IN SubscriptionManagerEndpointBehaviour BEHAVIOUR: " + e.getMessage());
			throw new TransportException(e);
		} 
	}


	@Override
	public ISubscriptionManager getSubscriptionManager() {
		return this.subsMgrEngine;
	}



	@Override
	public void setSubscriptionManager(
			ISubscriptionManager subscriptionManager) {
		this.subsMgrEngine = (SubscriptionManagerEngine) subscriptionManager;
	}

	@Override
	public URL getEvenTopicNamespaceDefinitionUrl() {
		return evenTopicNamespaceDefinitionUrl;
	}

	@Override
	public void setEvenTopicNamespaceDefinitionUrl(
			URL evenTopicNamespaceDefinitionUrl) throws ESBException {
		this.evenTopicNamespaceDefinitionUrl = evenTopicNamespaceDefinitionUrl;
		initNotification();
	}


	@Override
	public void setTopicSet(TopicSetType topicSet) throws ESBException {
		this.topicSet = topicSet;
		initNotification();
	}

	@Override
	public RenewResponse renew(Renew arg0) throws WsnbException, AbsWSStarFault {
		throw new WsnbException("renew operation is not currently implemented!!!");
	}

	@Override
	public UnsubscribeResponse unsubscribe(Unsubscribe unsubscribe)
	throws WsnbException, AbsWSStarFault {
		return this.getSubscriptionManager().unsubscribe(unsubscribe);
	}

	@Override
	public TopicSetType getTopicSet() {
		return topicSet;
	}

	@Override
	public TopicNamespaceType getTopicNs() {
		return topicNs;
	}





}
