package com.ebmwebsourcing.easyesb.soa.impl.endpoint.resolver;

import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;

import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;

import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeploy;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDescriptorType;


public class FileInDeployURIResolver implements URIResolver {


	private EJaxbDeploy deployer = null;

	@Override
	public Source resolve(String href, String base) throws TransformerException {
		Source s = null;
		System.out.println("********************** href: " + href);
		System.out.println("********************** base: " + base);
		String simpleFileName = href;
		if(href.lastIndexOf("/") > 0) {
			simpleFileName = href.substring(href.lastIndexOf("/") + 1);
		}
		synchronized(deployer) {
			if(deployer != null) {
				for(EJaxbDescriptorType dt: deployer.getResources()) {
					System.out.println("dt.FileURI() = " + dt.getFileURI());
					if(dt.getFileURI().contains(simpleFileName)) {
						try {
							s = new DOMSource(DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(dt.getAttachment().getInputStream()));
						} catch (Exception e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}
					}
				}
			}
		}
		deployer = null;
		return s;
	}

	public synchronized void setDeployer(EJaxbDeploy deployer) {
		this.deployer = deployer;
	}



}
