/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.soa.impl.endpoint;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Scope;
import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Description;

import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easyesb.constant.EasyESBFramework;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.SOAElement;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderProxyEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.EndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.external.ExternalListener;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.external.ExternalSender;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.external.ExternalServer;
import com.ebmwebsourcing.easyesb.soa10.api.type.ListenerInitialisationType;
import com.ebmwebsourcing.easyesb.soa10.api.type.ProviderProxyEndpointType;
import com.ebmwebsourcing.easyesb.soa10.api.type.SenderInitialisationType;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;

@Scope("COMPOSITE")
@org.oasisopen.sca.annotation.Service(value=ProviderProxyEndpoint.class, names="service")
@PolicySets("frascati:scaEasyPrimitive")
public class ProviderProxyEndpointImpl<M extends ProviderProxyEndpointType> extends ProviderEndpointImpl<M> implements ProviderProxyEndpoint<M> {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	private static Logger log = Logger.getLogger(ProviderProxyEndpointImpl.class.getName());

	private boolean isAdaptedDescription = false;
	
	private List<ExternalSender> senders = new ArrayList<ExternalSender>();


	// only used by frascati
	public ProviderProxyEndpointImpl() throws ESBException {
		super();
	}
	
	public ProviderProxyEndpointImpl(M model, SOAElement<?> parent) throws ESBException {
		super(model, parent);
	}
	
	@Override
	public void init() throws ESBException {
		super.init();
		try {
			for(SenderInitialisationType senderInit: this.getModel().getSenderInitialisations()) {
				ExternalSender sender = createExternalSenderFormClass((Class<? extends ExternalSender>) Class.forName(senderInit.getClassName()));
				sender.setExternalAddress(senderInit.getExternalProviderAddress());
				this.senders.add(sender);
			}
		} catch (ClassNotFoundException e) {
			throw new ESBException(e);
		}
	}

	private ExternalSender createExternalSenderFormClass(
			Class<? extends ExternalSender> behaviourClass) throws ESBException {
		ExternalSender res = null;
		if(behaviourClass != null) {
			if(behaviourClass.isInterface()) {
				throw new ESBException("Impossible to add an interface, give the implementation");
			}
			log.fine("create externalSender: " + behaviourClass);
			System.out.println("create externalSender: " + behaviourClass);
			try {
				Constructor<ExternalSender> constructor = (Constructor<ExternalSender>) behaviourClass.getConstructors()[0];
				res = constructor.newInstance(this);
			} catch (IllegalArgumentException e) {
				log.severe("ERROR : " + e.getMessage());
				e.printStackTrace();
				throw new ESBException(e);
			} catch (InstantiationException e) {
				log.severe("ERROR : " + e.getMessage());
				e.printStackTrace();
				throw new ESBException(e);
			} catch (IllegalAccessException e) {
				log.severe("ERROR : " + e.getMessage());
				e.printStackTrace();
				throw new ESBException(e);
			} catch (InvocationTargetException e) {
				log.severe("ERROR : " + e.getMessage());
				e.printStackTrace();
				throw new ESBException(e);
			} catch (SecurityException e) {
				log.severe("ERROR : " + e.getMessage());
				e.printStackTrace();
				throw new ESBException(e);
			} 
		}
		return res;
	}

	public Class<M> getModelClass() {
		Class<M> res = null;
		if(model != null) {
			res = (Class<M>) model.getClass();
		} else {
			res = (Class<M>) ProviderProxyEndpointType.class;
		}
		return res;
	}

	@Override
	public Description getDescription() {
		if(!isAdaptedDescription) {
			Description desc = null;
			try {
				desc = (Description) Factory.getInstance().wrap(SOAUtil.getInstance().getReader(EasyESBFramework.getInstance()).get().readDocument(this.getWSDLDescriptionAddress().toURL(), Definitions.class));

			} catch (MalformedURLException e) {
				desc = null;
			} catch (IOException e) {
				desc = null;
			} catch (XmlObjectReadException e) {
				desc = null;
			}
			if(desc != null) {
				super.setDescription(desc);
			}
		}
		return super.getDescription();
	}

	@Override
	public void setDescription(Description desc) {
		super.setDescription(desc);
		isAdaptedDescription = true;
	}

	@Override
	public ExternalSender[] getExternalSenders() {
		return this.senders.toArray(new ExternalSender[this.senders.size()]);
	}
	
}
