package com.ebmwebsourcing.easyesb.soa.impl.endpoint.behaviour.specific;

import java.util.logging.Logger;

import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.exchange10.api.type.PatternType;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderProxyEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.AbstractEndpointBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.specific.ProviderProxyBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.external.ExternalSender;
import com.ebmwebsourcing.easyesb.soa10.api.type.ProviderProxyEndpointType;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;

public class ProviderProxyBehaviourImpl extends AbstractEndpointBehaviourImpl implements ProviderProxyBehaviour {

	private static Logger log = Logger.getLogger(ProviderProxyBehaviourImpl.class.getName());
	
	
	public ProviderProxyBehaviourImpl(ProviderProxyEndpoint<? extends ProviderProxyEndpointType> ep) throws ESBException {
		super(ep);
	}


	@Override
	public void execute(Exchange exchange) throws TransportException {
		if(((ProviderProxyEndpoint)this.endpoint).getExternalSenders().length > 1) {
			log.warning("Sorry but several senders is not taking into account for the mmoment!!!!");
		}
		if(((ProviderProxyEndpoint)this.endpoint).getExternalSenders().length == 0) {
			throw new TransportException("No sender is plugged on endpoint!!!");
		}
		ExternalSender sender = ((ProviderProxyEndpoint)this.endpoint).getExternalSenders()[0];
		if(exchange.getPattern().equals(PatternType.IN_OUT)) {
			Exchange exchangeResponse = sender.sendSyncToExternalProvider(exchange);
			if(exchangeResponse == null) {
				throw new TransportException("The exchange returned cannot be null!!!!");
			}
			if(exchangeResponse != exchange) {
				throw new TransportException("The reference of exchange cannot be change!!!!");
			}
		} else {
			sender.sendToExternalProvider(exchange);
		}
	}
}
