/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.technical.service.resources.impl.interceptor;

import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.config.Configuration;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.Endpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.specific.NotificationProducerEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.specific.SubscriptionManagerEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.interceptors.AbstractEndpointInitializationInterceptor;
import com.ebmwebsourcing.easyesb.soa.api.interceptors.EndpointInitializationInterceptor;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.behaviour.specific.NotificationProducerEndpointBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.behaviour.specific.SubscriptionManagerEndpointBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.thread.NotificationProducerThreadImpl;
import com.petalslink.easyresources.execution_environment_connection_model.ResourceIdentifier;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;

public class CreationInitializationResourcesInterceptor
extends AbstractEndpointInitializationInterceptor
implements EndpointInitializationInterceptor {
    public CreationInitializationResourcesInterceptor(Endpoint ep) {
        super(ep);
    }

    public void processingCreation() throws ESBException {
        Configuration conf = ((NodeBehaviour)this.endpoint.getNode().findBehaviour(NodeBehaviour.class)).getConfiguration();
        try {
            if (this.endpoint instanceof ProviderEndpoint) {
                ResourceIdentifier rid = new ResourceIdentifier();
                rid.setId(this.endpoint.getQName().toString());
                rid.setResourceType("endpoint");
                Document notifPayload = SOAJAXBContext.getInstance().unmarshallAnyElement((Object)rid);
                QName topicUsed = new QName("http://www.petalslink.org/resources/event/1.0", "CreationResourcesTopic", "tns");
                String dialect = "http://docs.oasis-open.org/wsn/t-1/TopicExpression/Concrete";
                RegistryEndpointBehaviour registry = (RegistryEndpointBehaviour)this.endpoint.getNode().getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class);
                QName resourcesEndpointName = new QName(this.endpoint.getNode().getQName().getNamespaceURI(), "resourcesEndpoint_" + this.endpoint.getNode().getQName().getLocalPart());
                ProviderEndpoint resourcesEndpoint = (ProviderEndpoint)registry.getLocalEndpoint(resourcesEndpointName);
                if (resourcesEndpoint == null) {
                    throw new ESBException("Impossible to find resourcesEndpoint");
                }
                NotificationProducerEndpointBehaviour producerBehaviour = (NotificationProducerEndpointBehaviour)resourcesEndpoint.findBehaviour(NotificationProducerEndpointBehaviourImpl.class);
                if (producerBehaviour == null) {
                    throw new ESBException("Internal Error: This endpoint " + this.endpoint.getQName() + " has no producer behaviour to send notification");
                }
                SubscriptionManagerEndpointBehaviour subscriptionManagerBehaviour = (SubscriptionManagerEndpointBehaviour)resourcesEndpoint.findBehaviour(SubscriptionManagerEndpointBehaviourImpl.class);
                if (subscriptionManagerBehaviour == null) {
                    throw new ESBException("Internal Error: This endpoint " + this.endpoint.getQName() + " has no producer behaviour to send notification");
                }
                NotificationProducerThreadImpl notifier = new NotificationProducerThreadImpl(producerBehaviour, subscriptionManagerBehaviour, notifPayload, topicUsed, dialect);
                notifier.start();
            }
        }
        catch (SOAException e) {
            throw new ESBException((Throwable)e);
        }
    }
}

