package com.ebmwebsourcing.easyesb.cli.impl.command;

import java.util.List;

import com.ebmwebsourcing.easyesb.cli.impl.AbstractCommand;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.esstar.management.UserManagementClient;


public class BindCommand extends AbstractCommand<UserManagementClient> {

	private String url;
	
	private String wsdl;
	
	public BindCommand(UserManagementClient client) throws ESBException {
		super(client);
		this.setName("Bind");
		this.setDescription("Bind WS to node");
		this.setShortcut("b");
	}
	
	@Override
	public void execute() {
		try {
			String res = this.getClient().bind(this.url, this.wsdl);
			setResult(res);
			this.resultCode = AbstractCommand.OK_CODE;
			
		} catch (Throwable e) {
			setResult(e.getLocalizedMessage());
			this.resultCode = AbstractCommand.ERROR_CODE;
			
		}
		
	}

	@Override
	protected int doProcess(List<String> args) {
		this.url = args.get(0);
		this.wsdl = args.get(1);
		execute();
		return this.resultCode;
		
	}

	@Override
	protected boolean validateArgs(List<String> args) {
		if(args.size() == 2){
			return true;
		}
		return false;
	}

	@Override
	public String toString() {
		return "b <url> <wsdl> \t\t\t\t\t{Bind/Import Web Service (SOAP) in the ESB node}";
	}
	
}
