/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.cli.impl.command;

import com.ebmwebsourcing.easyesb.cli.impl.AbstractCommand;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.esstar.management.UserManagementClientSOAP;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeploy;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeployResponse;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDescriptorType;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.activation.DataHandler;

public class DeployCommand
extends AbstractCommand<UserManagementClientSOAP> {
    private String mainResource;
    private List<String> resources = new ArrayList<String>();

    public DeployCommand(UserManagementClientSOAP client) throws ESBException {
        super(client);
        this.setName("Deploy");
        this.setShortcut("d");
        this.setDescription("deploy");
    }

    @Override
    public void execute() {
        try {
            EJaxbDeploy parameters = new EJaxbDeploy();
            EJaxbDescriptorType artifact = new EJaxbDescriptorType();
            artifact.setAttachment(new DataHandler(new File(this.mainResource).toURI().toURL()));
            artifact.setFileURI(new File(this.mainResource).toURI().toString());
            parameters.setMainResource(artifact);
            for (String s : this.resources) {
                EJaxbDescriptorType resource = new EJaxbDescriptorType();
                resource.setAttachment(new DataHandler(new File(s).toURI().toURL()));
                resource.setFileURI(new File(s).toURI().toString());
                parameters.getResources().add(resource);
            }
            EJaxbDeployResponse res = ((UserManagementClientSOAP)this.getClient()).deploy(parameters);
            this.setResult("deployment ok " + new File(this.mainResource).getName());
            this.resultCode = 1;
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.setResult(e.getLocalizedMessage());
            this.resultCode = -1;
        }
    }

    @Override
    protected int doProcess(List<String> args) {
        this.mainResource = args.get(0);
        if (args.size() > 1) {
            for (int i = 1; i < args.size(); ++i) {
                this.resources.add(args.get(i));
            }
        }
        this.execute();
        this.mainResource = null;
        this.resources.clear();
        return this.resultCode;
    }

    @Override
    protected boolean validateArgs(List<String> args) {
        return args.size() > 0;
    }

    public String toString() {
        return "d <main-resource> [<resource> ...] \t\t\t{Deploy resource (bpel) on ESB node}";
    }
}

