/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.cli.impl.command;

import com.ebmwebsourcing.easyesb.cli.api.Command;
import com.ebmwebsourcing.easyesb.cli.impl.AbstractCommand;
import com.ebmwebsourcing.easyesb.cli.impl.AbstractCommandManager;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import esstar.petalslink.com.service.management._1_0.ManagementException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public abstract class AbstractScriptCommand<C>
extends AbstractCommand<C> {
    private File confFile;
    protected AbstractCommandManager cm;

    public AbstractScriptCommand(C client, AbstractCommandManager cm) throws ESBException {
        super(client);
        this.setName("ConfParser");
        this.setDescription("Parse a XML Script file to execute administration commands.");
        this.setShortcut("s");
        this.cm = cm;
        this.setResult("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        try {
            if (this.confFile != null && this.confFile.exists()) {
                SAXBuilder builder = new SAXBuilder(false);
                Document jdom = builder.build(this.confFile);
                Element element = jdom.getRootElement();
                List servicesChildren = element.getChildren("Service", Command.NAMESPACE_JDOM);
                for (int i = 0; i < servicesChildren.size(); ++i) {
                    Element e = (Element)servicesChildren.get(i);
                    this.parseService(e);
                }
                this.resultCode = 1;
            }
        }
        catch (JDOMException e) {
            this.setResult(e.getLocalizedMessage());
            this.resultCode = -1;
        }
        catch (IOException e) {
            this.setResult(e.getLocalizedMessage());
            this.resultCode = -1;
        }
    }

    private void parseService(Element e) {
        ArrayList<String> address = new ArrayList<String>();
        address.add(e.getAttributeValue("url"));
        try {
            AbstractCommand connect = (AbstractCommand)this.cm.findCommand("c");
            int cres = connect.process(address);
            if (cres != 1) {
                this.resultCode = cres;
                return;
            }
            this.client = ((AbstractScriptCommand)this.cm.findCommand("s")).getClient();
        }
        catch (Exception ex) {
            this.setResult(ex.getLocalizedMessage());
            this.resultCode = -1;
        }
        List actions = e.getChildren("Action", Command.NAMESPACE_JDOM);
        for (int i = 0; i < actions.size(); ++i) {
            try {
                this.parseAction((Element)actions.get(i));
                continue;
            }
            catch (ManagementException e1) {
                System.err.println("Error while parsing action!!!");
            }
        }
    }

    private void parseAction(Element action) throws ManagementException {
        Element command = (Element)action.getChildren().get(0);
        if (command == null) {
            System.err.println("Error while parsing command!!!");
            return;
        }
        String res = null;
        res = this.executeAction(command);
        if (this.getResult() == null) {
            this.setResult(res);
        } else {
            this.setResult(this.getResult() + "\n" + res);
        }
    }

    public abstract String executeAction(Element var1);

    @Override
    public int doProcess(List<String> args) {
        int res = 1;
        this.confFile = new File(args.get(0));
        try {
            System.out.println("Script found: " + this.confFile.getCanonicalPath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.execute();
        res = this.resultCode;
        return res;
    }

    @Override
    protected boolean validateArgs(List<String> args) {
        if (args == null) {
            return false;
        }
        return args.size() == 1;
    }

    @Override
    public int process(List<String> args) {
        this.setResult(null);
        int result = 1;
        result = !this.validateArgs(args) ? -2 : this.doProcess(args);
        System.out.println(this.getResult());
        return result;
    }

    public String toString() {
        return "s <conf-file> \t\t\t\t\t{Parse Configuration Script File}";
    }
}

