/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.admin.client.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.ws.Holder;

import org.jdom.JDOMException;
import org.oasis_open.docs.wsn.bw_2.InvalidFilterFault;
import org.oasis_open.docs.wsn.bw_2.InvalidMessageContentExpressionFault;
import org.oasis_open.docs.wsn.bw_2.InvalidProducerPropertiesExpressionFault;
import org.oasis_open.docs.wsn.bw_2.InvalidTopicExpressionFault;
import org.oasis_open.docs.wsn.bw_2.NotifyMessageNotSupportedFault;
import org.oasis_open.docs.wsn.bw_2.SubscribeCreationFailedFault;
import org.oasis_open.docs.wsn.bw_2.TopicExpressionDialectUnknownFault;
import org.oasis_open.docs.wsn.bw_2.TopicNotSupportedFault;
import org.oasis_open.docs.wsn.bw_2.UnableToDestroySubscriptionFault;
import org.oasis_open.docs.wsn.bw_2.UnacceptableInitialTerminationTimeFault;
import org.oasis_open.docs.wsn.bw_2.UnrecognizedPolicyRequestFault;
import org.oasis_open.docs.wsn.bw_2.UnsupportedPolicyRequestFault;
import org.oasis_open.docs.wsrf.rpw_2.InvalidResourcePropertyQNameFault;
import org.oasis_open.docs.wsrf.rw_2.ResourceUnavailableFault;
import org.oasis_open.docs.wsrf.rw_2.ResourceUnknownFault;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPException;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPHandler;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPSender;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyesb.admin.client.api.AdminClient;
import com.ebmwebsourcing.wsstar.jaxb.notification.base.Notify;
import com.ebmwebsourcing.wsstar.jaxb.notification.base.Subscribe;
import com.ebmwebsourcing.wsstar.jaxb.notification.base.SubscribeResponse;
import com.ebmwebsourcing.wsstar.jaxb.notification.base.Unsubscribe;
import com.ebmwebsourcing.wsstar.jaxb.notification.base.UnsubscribeResponse;
import com.ebmwebsourcing.wsstar.jaxb.resource.resourceproperties.GetResourcePropertyResponse;

import easyesb.petalslink.com.data.admin._1.AddNeighBourNode;
import easyesb.petalslink.com.data.admin._1.AddNeighBourNodeResponse;
import easyesb.petalslink.com.data.admin._1.AddProperties;
import easyesb.petalslink.com.data.admin._1.AddPropertiesResponse;
import easyesb.petalslink.com.data.admin._1.AddSoapListener;
import easyesb.petalslink.com.data.admin._1.AddSoapListenerResponse;
import easyesb.petalslink.com.data.admin._1.AdminFault;
import easyesb.petalslink.com.data.admin._1.ConnectToGovernance;
import easyesb.petalslink.com.data.admin._1.CreateClientEndpoint;
import easyesb.petalslink.com.data.admin._1.CreateClientEndpointResponse;
import easyesb.petalslink.com.data.admin._1.CreateComponent;
import easyesb.petalslink.com.data.admin._1.CreateComponentResponse;
import easyesb.petalslink.com.data.admin._1.CreateProviderEndpoint;
import easyesb.petalslink.com.data.admin._1.CreateProviderEndpointResponse;
import easyesb.petalslink.com.data.admin._1.CreateService;
import easyesb.petalslink.com.data.admin._1.CreateServiceEndpoint;
import easyesb.petalslink.com.data.admin._1.CreateServiceEndpointResponse;
import easyesb.petalslink.com.data.admin._1.CreateServiceResponse;
import easyesb.petalslink.com.data.admin._1.Deploy;
import easyesb.petalslink.com.data.admin._1.DeployResponse;
import easyesb.petalslink.com.data.admin._1.ExposeServiceEndpointInSoap;
import easyesb.petalslink.com.data.admin._1.ExposeServiceEndpointInSoapResponse;
import easyesb.petalslink.com.data.admin._1.GetAdditionalContent;
import easyesb.petalslink.com.data.admin._1.GetAdditionalContentResponse;
import easyesb.petalslink.com.data.admin._1.GetBusinessEndpoints;
import easyesb.petalslink.com.data.admin._1.GetBusinessEndpointsResponse;
import easyesb.petalslink.com.data.admin._1.GetContent;
import easyesb.petalslink.com.data.admin._1.GetContentResponse;
import easyesb.petalslink.com.data.admin._1.GetExecutionEnvironmentInformation;
import easyesb.petalslink.com.data.admin._1.GetExecutionEnvironmentInformationResponse;
import easyesb.petalslink.com.data.admin._1.GetNodeInformations;
import easyesb.petalslink.com.data.admin._1.GetNodeInformationsResponse;
import easyesb.petalslink.com.data.admin._1.GetProperties;
import easyesb.petalslink.com.data.admin._1.GetPropertiesResponse;
import easyesb.petalslink.com.data.admin._1.GetResourceIdentifiers;
import easyesb.petalslink.com.data.admin._1.GetResourceIdentifiersResponse;
import easyesb.petalslink.com.data.admin._1.ImportSoapEndpoint;
import easyesb.petalslink.com.data.admin._1.ImportSoapEndpointResponse;
import easyesb.petalslink.com.data.admin._1.MoveEnpointToNode;
import easyesb.petalslink.com.data.admin._1.MoveEnpointToNodeResponse;
import easyesb.petalslink.com.data.admin._1.Stop;
import easyesb.petalslink.com.data.admin._1.StoreBpel;
import easyesb.petalslink.com.data.admin._1.StoreBpelResponse;
import easyesb.petalslink.com.data.admin._1.UnconnectToGovernance;
import easyesb.petalslink.com.data.admin._1.WrapSoapEndpoint;
import easyesb.petalslink.com.data.admin._1.WrapSoapEndpointResponse;
import easyesb.petalslink.com.service.admin._1_0.AdminExceptionMsg;

public class AdminClientImplSOAP implements AdminClient {

	protected String address = null;

	protected SOAPSender soapSender = null;

	protected SOAPHandler soapHandler = null;

	public AdminClientImplSOAP(String address) {
		this.address = address;
		this.soapSender = new SOAPSender();
		this.soapHandler = new SOAPHandler();
		try {
			SOAJAXBContext.getInstance().addOtherObjectFactory(easyesb.petalslink.com.data.admin._1.ObjectFactory.class);
		} catch (SOAException e) {
			e.printStackTrace();
		}
	}


	@Override
	public String exposeServiceEndpointInSoap(QName serviceName,
			String providerEndpointName) throws AdminExceptionMsg {
		ExposeServiceEndpointInSoapResponse response = null;
		try {
			ExposeServiceEndpointInSoap payload = new ExposeServiceEndpointInSoap();
			payload.setServiceName(serviceName);
			payload.setProviderEndpointName(providerEndpointName);
			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(payload));
			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://com.petalslink.easyesb/service/admin/1.0/exposeServiceEndpointInSoap");
			if(soapHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				doc.appendChild((Element)doc.importNode((Element) soapHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
				AdminFault fault = SOAJAXBContext.getInstance().marshallAnyType(doc, AdminFault.class);
				System.err.println("\n\nError message: \n" + fault.getMessage());
				System.err.println("Stack trace: \n" + fault.getStacktrace());
				throw new AdminExceptionMsg("Business Fault", fault);
			}

			// get bpel store response
			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
			response = SOAJAXBContext.getInstance().marshallAnyType(doc, ExposeServiceEndpointInSoapResponse.class);
		} catch (JDOMException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		} catch (SOAException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		} catch (SOAPException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		} catch (ParserConfigurationException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		}
		return response.getSoapAddress();
	}

	@Override
	public String createServiceEndpoint(QName componentName, QName serviceName,
			String classServiceName, String providerEndpointName,
			String classProviderEndpointName,
			String classProviderEndpointBehaviourName, String wsdl)
					throws AdminExceptionMsg {
		CreateServiceEndpointResponse response = null;
		try {
			CreateServiceEndpoint payload = new CreateServiceEndpoint();
			payload.setComponentName(componentName);
			payload.setServiceName(serviceName);
			payload.setClassServiceName(classServiceName);
			payload.setProviderEndpointName(providerEndpointName);
			payload.setClassProviderEndpointName(classProviderEndpointName);
			payload.setClassProviderEndpointBehaviourName(classProviderEndpointBehaviourName);
			payload.setWsdl(wsdl);
			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(payload));
			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://com.petalslink.easyesb/service/admin/1.0/createServiceEndpoint");
			if(soapHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				doc.appendChild((Element)doc.importNode((Element) soapHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
				AdminFault fault = SOAJAXBContext.getInstance().marshallAnyType(doc, AdminFault.class);
				System.err.println("\n\nError message: \n" + fault.getMessage());
				System.err.println("Stack trace: \n" + fault.getStacktrace());
				throw new AdminExceptionMsg("Business Fault", fault);
			}

			// get bpel store response
			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
			response = SOAJAXBContext.getInstance().marshallAnyType(doc, CreateServiceEndpointResponse.class);
		} catch (JDOMException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		} catch (SOAException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		} catch (SOAPException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		} catch (ParserConfigurationException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		}
		return response.getEndpointName();
	}

	@Override
	public void createProviderEndpoint(QName serviceName,
			Holder<String> providerEndpointName,
			String classProviderEndpointName,
			String classProviderEndpointBehaviourName, String wsdl)
					throws AdminExceptionMsg {
		CreateProviderEndpointResponse response = null;
		try {
			CreateProviderEndpoint payload = new CreateProviderEndpoint();
			payload.setServiceName(serviceName);
			payload.setProviderEndpointName(providerEndpointName.value);
			payload.setClassProviderEndpointName(classProviderEndpointName);
			payload.setClassProviderEndpointBehaviourName(classProviderEndpointBehaviourName);
			payload.setWsdl(wsdl);
			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(payload));
			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://com.petalslink.easyesb/service/admin/1.0/createProviderEndpoint");
			if(soapHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				doc.appendChild((Element)doc.importNode((Element) soapHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
				AdminFault fault = SOAJAXBContext.getInstance().marshallAnyType(doc, AdminFault.class);
				System.err.println("\n\nError message: \n" + fault.getMessage());
				System.err.println("Stack trace: \n" + fault.getStacktrace());
				throw new AdminExceptionMsg("Business Fault", fault);
			}

			// get bpel store response
			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
			response = SOAJAXBContext.getInstance().marshallAnyType(doc, CreateProviderEndpointResponse.class);

			providerEndpointName.value = response.getProviderEndpointName();
		} catch (JDOMException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		} catch (SOAException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		} catch (SOAPException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		} catch (ParserConfigurationException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		}
	}

	@Override
	public void createService(QName componentName, Holder<QName> serviceName,
			String classServiceName) throws AdminExceptionMsg {
		CreateServiceResponse response = null;
		try {
			CreateService payload = new CreateService();
			payload.setComponentName(componentName);
			payload.setServiceName(serviceName.value);
			payload.setClassServiceName(classServiceName);
			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(payload));
			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://com.petalslink.easyesb/service/admin/1.0/createService");
			if(soapHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				doc.appendChild((Element)doc.importNode((Element) soapHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
				AdminFault fault = SOAJAXBContext.getInstance().marshallAnyType(doc, AdminFault.class);
				System.err.println("\n\nError message: \n" + fault.getMessage());
				System.err.println("Stack trace: \n" + fault.getStacktrace());
				throw new AdminExceptionMsg("Business Fault", fault);
			}

			// get bpel store response
			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
			response = SOAJAXBContext.getInstance().marshallAnyType(doc, CreateServiceResponse.class);

			serviceName.value = response.getServiceName();
		} catch (JDOMException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		} catch (SOAException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		} catch (SOAPException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		} catch (ParserConfigurationException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		}
	}

	@Override
	public GetNodeInformationsResponse getNodeInformations(
			GetNodeInformations payload) throws AdminExceptionMsg {
		GetNodeInformationsResponse response = null;
		try {
			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(payload));
			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://com.petalslink.easyesb/service/admin/1.0/getNodeInformations");
			if(soapHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				doc.appendChild((Element)doc.importNode((Element) soapHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
				AdminFault fault = SOAJAXBContext.getInstance().marshallAnyType(doc, AdminFault.class);
				System.err.println("\n\nError message: \n" + fault.getMessage());
				System.err.println("Stack trace: \n" + fault.getStacktrace());
				throw new AdminExceptionMsg("Business Fault", fault);
			}

			// get bpel store response
			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
			response = SOAJAXBContext.getInstance().marshallAnyType(doc, GetNodeInformationsResponse.class);
		} catch (JDOMException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		} catch (SOAException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		} catch (SOAPException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		} catch (ParserConfigurationException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		}
		return response;
	}

	@Override
	public AddSoapListenerResponse addSoapListener(AddSoapListener payload)
			throws AdminExceptionMsg {
		AddSoapListenerResponse response = null;
		try {

			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(payload));
			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://com.petalslink.easyesb/service/admin/1.0/addSoapListener");
			if(soapHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				doc.appendChild((Element)doc.importNode((Element) soapHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
				AdminFault fault = SOAJAXBContext.getInstance().marshallAnyType(doc, AdminFault.class);
				System.err.println("\n\nError message: \n" + fault.getMessage());
				System.err.println("Stack trace: \n" + fault.getStacktrace());
				throw new AdminExceptionMsg("Business Fault", fault);
			}

			// get bpel store response
			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
			response = SOAJAXBContext.getInstance().marshallAnyType(doc, AddSoapListenerResponse.class);
		} catch (JDOMException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		} catch (SOAException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		} catch (SOAPException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		} catch (ParserConfigurationException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		}
		return response;
	}

	@Override
	public String importSoapEndpoint(String soapAddress, String wsdl)
			throws AdminExceptionMsg {
		ImportSoapEndpointResponse response = null;
		try {
			ImportSoapEndpoint payload = new ImportSoapEndpoint();
			payload.setSoapAddress(soapAddress);
			payload.setWsdl(wsdl);
			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(payload));
			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://com.petalslink.easyesb/service/admin/1.0/importSoapEndpoint");
			if(soapHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				doc.appendChild((Element)doc.importNode((Element) soapHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
				AdminFault fault = SOAJAXBContext.getInstance().marshallAnyType(doc, AdminFault.class);
				System.err.println("\n\nError message: \n" + fault.getMessage());
				System.err.println("Stack trace: \n" + fault.getStacktrace());
				throw new AdminExceptionMsg("Business Fault", fault);
			}

			// get bpel store response
			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
			response = SOAJAXBContext.getInstance().marshallAnyType(doc, ImportSoapEndpointResponse.class);
		} catch (JDOMException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		} catch (SOAException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		} catch (SOAPException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		} catch (ParserConfigurationException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		}
		return response.getEndpointName();
	}

	@Override
	public GetBusinessEndpointsResponse getBusinessEndpoints(
			GetBusinessEndpoints payload) throws AdminExceptionMsg {
		GetBusinessEndpointsResponse response = null;
		try {
			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(payload));
			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://com.petalslink.easyesb/service/admin/1.0/getBusinessEndpoints");
			if(soapHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				doc.appendChild((Element)doc.importNode((Element) soapHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
				AdminFault fault = SOAJAXBContext.getInstance().marshallAnyType(doc, AdminFault.class);
				System.err.println("\n\nError message: \n" + fault.getMessage());
				System.err.println("Stack trace: \n" + fault.getStacktrace());
				throw new AdminExceptionMsg("Business Fault", fault);
			}

			// get bpel store response
			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
			response = SOAJAXBContext.getInstance().marshallAnyType(doc, GetBusinessEndpointsResponse.class);
		} catch (JDOMException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		} catch (SOAException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		} catch (SOAPException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		} catch (ParserConfigurationException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		}
		return response;
	}

	@Override
	public void createClientEndpoint(Holder<QName> clientEndpointName,
			String classClientEndpointName,
			String classClientEndpointBehaviourName) throws AdminExceptionMsg {
		CreateClientEndpointResponse response = null;
		try {
			CreateClientEndpoint payload = new CreateClientEndpoint();
			payload.setClientEndpointName(clientEndpointName.value);
			payload.setClassClientEndpointName(classClientEndpointName);
			payload.setClassClientEndpointBehaviourName(classClientEndpointBehaviourName);

			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(payload));
			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://com.petalslink.easyesb/service/admin/1.0/createClientEndpoint");
			if(soapHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				doc.appendChild((Element)doc.importNode((Element) soapHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
				AdminFault fault = SOAJAXBContext.getInstance().marshallAnyType(doc, AdminFault.class);
				System.err.println("\n\nError message: \n" + fault.getMessage());
				System.err.println("Stack trace: \n" + fault.getStacktrace());
				throw new AdminExceptionMsg("Business Fault", fault);
			}

			// get bpel store response
			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
			response = SOAJAXBContext.getInstance().marshallAnyType(doc, CreateClientEndpointResponse.class);

			clientEndpointName.value = response.getClientEndpointName();
		} catch (JDOMException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		} catch (SOAException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		} catch (SOAPException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		} catch (ParserConfigurationException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		}
	}

	@Override
	public String wrapSoapEndpoint(String soapAddress, String wsdl,
			List<String> interceptorClassName) throws AdminExceptionMsg {
		WrapSoapEndpointResponse response = null;
		try {
			WrapSoapEndpoint payload = new WrapSoapEndpoint();
			payload.setSoapAddress(soapAddress);
			payload.setWsdl(wsdl);
			if(interceptorClassName != null) {
				for(String interceptor: interceptorClassName) {
					payload.getInterceptorClassName().add(interceptor);
				}
			}
			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(payload));
			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://com.petalslink.easyesb/service/admin/1.0/wrapSoapEndpoint");
			if(soapHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				doc.appendChild((Element)doc.importNode((Element) soapHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
				AdminFault fault = SOAJAXBContext.getInstance().marshallAnyType(doc, AdminFault.class);
				System.err.println("\n\nError message: \n" + fault.getMessage());
				System.err.println("Stack trace: \n" + fault.getStacktrace());
				throw new AdminExceptionMsg("Business Fault", fault);
			}

			// get bpel store response
			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
			response = SOAJAXBContext.getInstance().marshallAnyType(doc, WrapSoapEndpointResponse.class);

			soapAddress = response.getConsumerSoapAddress();
			return soapAddress;
		} catch (JDOMException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		} catch (SOAException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		} catch (SOAPException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		} catch (ParserConfigurationException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		}
	}

	@Override
	public void createComponent(Holder<QName> componentName,
			String classComponentName) throws AdminExceptionMsg {
		CreateComponentResponse response = null;
		try {
			CreateComponent payload = new CreateComponent();
			payload.setComponentName(componentName.value);
			payload.setClassComponentName(classComponentName);
			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(payload));
			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://com.petalslink.easyesb/service/admin/1.0/createComponent");
			if(soapHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				doc.appendChild((Element)doc.importNode((Element) soapHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
				AdminFault fault = SOAJAXBContext.getInstance().marshallAnyType(doc, AdminFault.class);
				System.err.println("\n\nError message: \n" + fault.getMessage());
				System.err.println("Stack trace: \n" + fault.getStacktrace());
				throw new AdminExceptionMsg("Business Fault", fault);
			}

			// get bpel store response
			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
			response = SOAJAXBContext.getInstance().marshallAnyType(doc, CreateComponentResponse.class);

			componentName.value = response.getComponentName();
		} catch (JDOMException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		} catch (SOAException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		} catch (SOAPException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		} catch (ParserConfigurationException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		}
	}

	@Override
	public MoveEnpointToNodeResponse moveEnpointToNode(
			MoveEnpointToNode payload) throws AdminExceptionMsg {
		MoveEnpointToNodeResponse response = null;
		try {
			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(payload));
			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://com.petalslink.easyesb/service/admin/1.0/moveEnpointToNode");
			if(soapHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				doc.appendChild((Element)doc.importNode((Element) soapHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
				AdminFault fault = SOAJAXBContext.getInstance().marshallAnyType(doc, AdminFault.class);
				System.err.println("\n\nError message: \n" + fault.getMessage());
				System.err.println("Stack trace: \n" + fault.getStacktrace());
				throw new AdminExceptionMsg("Business Fault", fault);
			}

			// get bpel store response
			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
			response = SOAJAXBContext.getInstance().marshallAnyType(doc, MoveEnpointToNodeResponse.class);
		} catch (JDOMException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		} catch (SOAException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		} catch (SOAPException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		} catch (ParserConfigurationException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		}
		return response;
	}

	@Override
	public AddNeighBourNodeResponse addNeighBourNode(AddNeighBourNode payload)
			throws AdminExceptionMsg {
		AddNeighBourNodeResponse response = null;
		try {
			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(payload));
			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://com.petalslink.easyesb/service/admin/1.0/addNeighBourNode");
			if(soapHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				doc.appendChild((Element)doc.importNode((Element) soapHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
				AdminFault fault = SOAJAXBContext.getInstance().marshallAnyType(doc, AdminFault.class);
				System.err.println("\n\nError message: \n" + fault.getMessage());
				System.err.println("Stack trace: \n" + fault.getStacktrace());
				throw new AdminExceptionMsg("Business Fault", fault);
			}

			// get bpel store response
			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
			response = SOAJAXBContext.getInstance().marshallAnyType(doc, AddNeighBourNodeResponse.class);
		} catch (JDOMException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		} catch (SOAException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		} catch (SOAPException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		} catch (ParserConfigurationException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		}
		return response;
	}

	@Override
	public List<String> storeBpel(String bpelUrl) throws AdminExceptionMsg {
		StoreBpelResponse response = null;
		try {
			StoreBpel payload = new StoreBpel();
			payload.setBpelUrl(bpelUrl);
			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(payload));
			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://com.petalslink.easyesb/service/admin/1.0/storeBpel");
			if(soapHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				doc.appendChild((Element)doc.importNode((Element) soapHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
				AdminFault fault = SOAJAXBContext.getInstance().marshallAnyType(doc, AdminFault.class);
				System.err.println("\n\nError message: \n" + fault.getMessage());
				System.err.println("Stack trace: \n" + fault.getStacktrace());
				throw new AdminExceptionMsg("Business Fault", fault);
			}

			// get bpel store response
			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
			response = SOAJAXBContext.getInstance().marshallAnyType(doc, StoreBpelResponse.class);
		} catch (JDOMException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		} catch (SOAException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		} catch (SOAPException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		} catch (ParserConfigurationException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		}
		return response.getBpelEndpointAddress();
	}

	@Override
	public void stop() {
		try {
			Stop payload = new Stop();
			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(payload));
			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://com.petalslink.easyesb/service/admin/1.0/stop");
			if(soapResponse != null && soapHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				doc.appendChild((Element)doc.importNode((Element) soapHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
				AdminFault fault = SOAJAXBContext.getInstance().marshallAnyType(doc, AdminFault.class);
				System.err.println("\n\nError message: \n" + fault.getMessage());
				System.err.println("Stack trace: \n" + fault.getStacktrace());
			}

		} catch (JDOMException e) {
			e.printStackTrace();
		} catch (SOAException e) {
			e.printStackTrace();
		} catch (SOAPException e) {
			e.printStackTrace();
		} catch (ParserConfigurationException e) {
			e.printStackTrace();
		}
	}



	@Override
	public GetPropertiesResponse getProperties(GetProperties payload) throws AdminExceptionMsg {
		GetPropertiesResponse response = null;
		try {
			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(payload));
			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://com.petalslink.easyesb/service/admin/1.0/getProperties");
			if(soapHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				doc.appendChild((Element)doc.importNode((Element) soapHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
				AdminFault fault = SOAJAXBContext.getInstance().marshallAnyType(doc, AdminFault.class);
				System.err.println("\n\nError message: \n" + fault.getMessage());
				System.err.println("Stack trace: \n" + fault.getStacktrace());
				throw new AdminExceptionMsg("Business Fault", fault);
			}

			// get bpel store response
			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
			response = SOAJAXBContext.getInstance().marshallAnyType(doc, GetPropertiesResponse.class);
		} catch (JDOMException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		} catch (SOAException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		} catch (SOAPException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		} catch (ParserConfigurationException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		}
		return response;
	}


	@Override
	public AddPropertiesResponse addProperties(AddProperties payload)
			throws AdminExceptionMsg {
		AddPropertiesResponse response = null;
		try {
			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(payload));
			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://com.petalslink.easyesb/service/admin/1.0/addProperties");
			if(soapHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				doc.appendChild((Element)doc.importNode((Element) soapHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
				AdminFault fault = SOAJAXBContext.getInstance().marshallAnyType(doc, AdminFault.class);
				System.err.println("\n\nError message: \n" + fault.getMessage());
				System.err.println("Stack trace: \n" + fault.getStacktrace());
				throw new AdminExceptionMsg("Business Fault", fault);
			}

			// get bpel store response
			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
			response = SOAJAXBContext.getInstance().marshallAnyType(doc, AddPropertiesResponse.class);
		} catch (JDOMException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		} catch (SOAException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		} catch (SOAPException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		} catch (ParserConfigurationException e) {
			throw new AdminExceptionMsg("Technical Fault", e);
		}
		return response;
	}

	@Override
	public String getAddress() {
		return address;
	}


	@Override
	public UnsubscribeResponse unsubscribe(Unsubscribe unsubscribeRequest)
			throws ResourceUnknownFault, UnableToDestroySubscriptionFault {

		UnsubscribeResponse res = new UnsubscribeResponse();
		try{


			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(unsubscribeRequest));
			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://com.petalslink.easyesb/service/admin/1.0/unSubscribe");
			if(soapHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				doc.appendChild((Element)doc.importNode((Element) soapHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
				ResourceUnknownFault fault = SOAJAXBContext.getInstance().marshallAnyType(doc, ResourceUnknownFault.class);
				System.err.println("\n\nError message: \n" + fault.getMessage());
				System.err.println("Stack trace: \n" + fault.getStackTrace());
				throw new ResourceUnknownFault("Business Fault", fault);
			}

			// get bpel store response
			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
			res = SOAJAXBContext.getInstance().marshallAnyType(doc, UnsubscribeResponse.class);
		} catch (Exception e) {
			throw new RuntimeException("Technical Fault", e);
		} 

		return res;
	}


	@Override
	public GetResourceIdentifiersResponse getResourceIdentifiers(GetResourceIdentifiers parameters)
			throws AdminExceptionMsg {

		GetResourceIdentifiersResponse res = new GetResourceIdentifiersResponse();
		try{


			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(parameters));
			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://com.petalslink.easyesb/service/admin/1.0/getResourceIdentifiers");
			if(soapHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				doc.appendChild((Element)doc.importNode((Element) soapHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
				AdminExceptionMsg fault = SOAJAXBContext.getInstance().marshallAnyType(doc, AdminExceptionMsg.class);
				System.err.println("\n\nError message: \n" + fault.getMessage());
				System.err.println("Stack trace: \n" + fault.getStackTrace());
				throw new AdminExceptionMsg("Business Fault", fault);
			}

			// get bpel store response
			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
			res = SOAJAXBContext.getInstance().marshallAnyType(doc, GetResourceIdentifiersResponse.class);
		} catch (Exception e) {
			throw new RuntimeException("Technical Fault", e);
		} 

		return res;

	}


	@Override
	public GetContentResponse getContent(GetContent parameters) throws AdminExceptionMsg {

		GetContentResponse res = new GetContentResponse();
		try{


			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(parameters));
			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://com.petalslink.easyesb/service/admin/1.0/getContent");
			if(soapHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				doc.appendChild((Element)doc.importNode((Element) soapHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
				AdminExceptionMsg fault = SOAJAXBContext.getInstance().marshallAnyType(doc, AdminExceptionMsg.class);
				System.err.println("\n\nError message: \n" + fault.getMessage());
				System.err.println("Stack trace: \n" + fault.getStackTrace());
				throw new AdminExceptionMsg("Business Fault", fault);
			}

			// get bpel store response
			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
			res = SOAJAXBContext.getInstance().marshallAnyType(doc, GetContentResponse.class);
		} catch (Exception e) {
			throw new RuntimeException("Technical Fault", e);
		} 

		return res;
	}

	@Override
	public GetExecutionEnvironmentInformationResponse getExecutionEnvironmentInformation(
			GetExecutionEnvironmentInformation parameters) throws AdminExceptionMsg {

		GetExecutionEnvironmentInformationResponse res = new GetExecutionEnvironmentInformationResponse();
		try{


			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(parameters));
			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://com.petalslink.easyesb/service/admin/1.0/getExecutionEnvironmentInformation");
			if(soapHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				doc.appendChild((Element)doc.importNode((Element) soapHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
				AdminExceptionMsg fault = SOAJAXBContext.getInstance().marshallAnyType(doc, AdminExceptionMsg.class);
				System.err.println("\n\nError message: \n" + fault.getMessage());
				System.err.println("Stack trace: \n" + fault.getStackTrace());
				throw new AdminExceptionMsg("Business Fault", fault);
			}

			// get bpel store response
			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
			res = SOAJAXBContext.getInstance().marshallAnyType(doc, GetExecutionEnvironmentInformationResponse.class);
		} catch (Exception e) {
			throw new RuntimeException("Technical Fault", e);
		} 

		return res;

	}


	@Override
	public GetAdditionalContentResponse getAdditionalContent(
			GetAdditionalContent getAdditionalContentRequest) throws AdminExceptionMsg {
		GetAdditionalContentResponse res = new GetAdditionalContentResponse();
		try{


			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(getAdditionalContentRequest));
			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://com.petalslink.easyesb/service/admin/1.0/getAdditionalContent");
			if(soapHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				doc.appendChild((Element)doc.importNode((Element) soapHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
				AdminExceptionMsg fault = SOAJAXBContext.getInstance().marshallAnyType(doc, AdminExceptionMsg.class);
				System.err.println("\n\nError message: \n" + fault.getMessage());
				System.err.println("Stack trace: \n" + fault.getStackTrace());
				throw new AdminExceptionMsg("Business Fault", fault);
			}

			// get bpel store response
			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
			res = SOAJAXBContext.getInstance().marshallAnyType(doc, GetAdditionalContentResponse.class);
		} catch (Exception e) {
			throw new RuntimeException("Technical Fault", e);
		} 

		return res;

	}




	@Override
	public GetResourcePropertyResponse getResourceProperty(QName getResourcePropertyRequest)
			throws ResourceUnavailableFault, InvalidResourcePropertyQNameFault,
			ResourceUnknownFault {


		String req = "<wsrf-rp:GetResourceProperty xmlns:wsrf-rp=\"http://docs.oasis-open.org/wsrf/rp-2\"\n" + 
				"xmlns:t=\"" + getResourcePropertyRequest.getNamespaceURI() + "\" >\n" + 
				"  		t:" + getResourcePropertyRequest.getLocalPart() + "\n" + 
				"</wsrf-rp:GetResourceProperty>\n";
		GetResourcePropertyResponse res = new GetResourcePropertyResponse();
		try{

			InputStream is = new ByteArrayInputStream(req.getBytes());
			Document payload = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(is);
			Document soapRequest = SOAPSender.createSOAPMessageRequest(payload);
			is.close();
			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://com.petalslink.easyesb/service/admin/1.0/getResourceProperty");
			if(soapHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				doc.appendChild((Element)doc.importNode((Element) soapHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
				ResourceUnknownFault fault = SOAJAXBContext.getInstance().marshallAnyType(doc, ResourceUnknownFault.class);
				System.err.println("\n\nError message: \n" + fault.getMessage());
				System.err.println("Stack trace: \n" + fault.getStackTrace());
				throw new ResourceUnknownFault("Business Fault", fault);
			}

			// get response
			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
			res = SOAJAXBContext.getInstance().marshallAnyType(doc, GetResourcePropertyResponse.class);
		} catch (Exception e) {
			throw new RuntimeException("Technical Fault", e);
		} 

		return res;


	}


	@Override
	public DeployResponse deploy(Deploy parameters) throws AdminExceptionMsg {

		DeployResponse res = new DeployResponse();
		try{


			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(parameters));
			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://com.petalslink.easyesb/service/admin/1.0/deploy");
			if(soapHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				doc.appendChild((Element)doc.importNode((Element) soapHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
				AdminExceptionMsg fault = SOAJAXBContext.getInstance().marshallAnyType(doc, AdminExceptionMsg.class);
				System.err.println("\n\nError message: \n" + fault.getMessage());
				System.err.println("Stack trace: \n" + fault.getStackTrace());
				throw new AdminExceptionMsg("Business Fault", fault);
			}

			// get bpel store response
			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
			res = SOAJAXBContext.getInstance().marshallAnyType(doc, DeployResponse.class);
		} catch (Exception e) {
			throw new RuntimeException("Technical Fault", e);
		} 

		return res;

	}


	@Override
	public SubscribeResponse subscribe(Subscribe subscribeRequest) throws TopicNotSupportedFault,
	UnsupportedPolicyRequestFault, InvalidTopicExpressionFault,
	UnrecognizedPolicyRequestFault, UnacceptableInitialTerminationTimeFault,
	NotifyMessageNotSupportedFault, ResourceUnknownFault,
	InvalidMessageContentExpressionFault, SubscribeCreationFailedFault, InvalidFilterFault,
	InvalidProducerPropertiesExpressionFault, TopicExpressionDialectUnknownFault {


		SubscribeResponse res = new SubscribeResponse();
		try{


			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(subscribeRequest));
			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://com.petalslink.easyesb/service/admin/1.0/subscribe");
			if(soapHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				doc.appendChild((Element)doc.importNode((Element) soapHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
				TopicNotSupportedFault fault = SOAJAXBContext.getInstance().marshallAnyType(doc, TopicNotSupportedFault.class);
				System.err.println("\n\nError message: \n" + fault.getMessage());
				System.err.println("Stack trace: \n" + fault.getStackTrace());
				throw new TopicNotSupportedFault("Business Fault", fault);
			}

			// get bpel store response
			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
			res = SOAJAXBContext.getInstance().marshallAnyType(doc, SubscribeResponse.class);
		} catch (Exception e) {
			throw new RuntimeException("Technical Fault", e);
		} 

		return res;


	}


	@Override
	public void notify(Notify notify) {
		try {
			Notify payload = new Notify();
			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(payload));
			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://com.petalslink.easyesb/service/admin/1.0/notify");
			if(soapResponse != null && soapHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				doc.appendChild((Element)doc.importNode((Element) soapHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
				SOAPException fault = SOAJAXBContext.getInstance().marshallAnyType(doc, SOAPException.class);
				System.err.println("\n\nError message: \n" + fault.getMessage());
				System.err.println("Stack trace: \n" + fault.getStackTrace());
			}

		} catch (JDOMException e) {
			e.printStackTrace();
		} catch (SOAException e) {
			e.printStackTrace();
		} catch (SOAPException e) {
			e.printStackTrace();
		} catch (ParserConfigurationException e) {
			e.printStackTrace();
		}
	}


	@Override
	public void connectToGovernance(String address) throws AdminExceptionMsg {
		try {
			ConnectToGovernance payload = new ConnectToGovernance();
			payload.setAddress(address);
			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(payload));
			Document soapResponse = soapSender.sendSoapRequest(soapRequest, this.address, "http://com.petalslink.easyesb/service/admin/1.0/connectToGovernance");
			System.out.println("connectToGovernance: soapResponse = " + XMLPrettyPrinter.prettyPrint(soapResponse));
			if(soapResponse != null && SOAPHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				if(SOAPHandler.getFaultDetails(soapResponse).size() > 0) {
					doc.appendChild((Element)doc.importNode((Element) SOAPHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
					SOAPException fault = SOAJAXBContext.getInstance().marshallAnyType(doc, SOAPException.class);
					System.err.println("\n\nError message: \n" + fault.getMessage());
					System.err.println("Stack trace: \n" + fault.getStackTrace());
					throw new AdminExceptionMsg("Business Fault", fault);
				} else {
					throw new AdminExceptionMsg("Technical Fault:\n" +  XMLPrettyPrinter.prettyPrint(soapResponse));
				}
			}

		} catch (JDOMException e) {
			e.printStackTrace();
		} catch (SOAException e) {
			e.printStackTrace();
		} catch (SOAPException e) {
			e.printStackTrace();
		} catch (ParserConfigurationException e) {
			e.printStackTrace();
		}
	}


	@Override
	public void unconnectToGovernance(String address) throws AdminExceptionMsg {
		try {
			UnconnectToGovernance payload = new UnconnectToGovernance();
			payload.setAddress(address);
			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(payload));
			Document soapResponse = soapSender.sendSoapRequest(soapRequest, this.address, "http://com.petalslink.easyesb/service/admin/1.0/unconnectToGovernance");
			if(soapResponse != null && soapHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				if(SOAPHandler.getFaultDetails(soapResponse).size() > 0) {
					doc.appendChild((Element)doc.importNode((Element) SOAPHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
					SOAPException fault = SOAJAXBContext.getInstance().marshallAnyType(doc, SOAPException.class);
					System.err.println("\n\nError message: \n" + fault.getMessage());
					System.err.println("Stack trace: \n" + fault.getStackTrace());
					throw new AdminExceptionMsg("Business Fault", fault);
				} else {
					throw new AdminExceptionMsg("Technical Fault:\n" +  XMLPrettyPrinter.prettyPrint(soapResponse));
				}
			}

		} catch (JDOMException e) {
			e.printStackTrace();
		} catch (SOAException e) {
			e.printStackTrace();
		} catch (SOAPException e) {
			e.printStackTrace();
		} catch (ParserConfigurationException e) {
			e.printStackTrace();
		}
	}

}
