package com.ebmwebsourcing.easyschema10.impl;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.with.WithId;
import com.ebmwebsourcing.easybox.api.with.WithOtherAttributes;
import com.ebmwebsourcing.easyschema10.api.with.WithAnnotation;

import easybox.org.w3._2001.xmlschema.EJaxbAnnotated;

abstract class AbstractAnnotatedImpl<Model extends EJaxbAnnotated> extends AbstractOpenAttrsImpl<Model> implements
        WithId, WithOtherAttributes, WithAnnotation {

    protected AbstractAnnotatedImpl(XmlContext xmlContext, Model jaxbModel) {
        super(xmlContext, jaxbModel);
    }

    @Override
    public final com.ebmwebsourcing.easyschema10.api.element.Annotation getAnnotation() {
        if (!hasAnnotation())
            return null;
        return new AnnotationImpl(getXmlContext(), getModelObject().getAnnotation());
    }

    @Override
    public final String getId() {
        return getModelObject().getId();
    }


    @Override
    public boolean hasAnnotation() {
        return getModelObject().getAnnotation() != null;
    }

    @Override
    public final void setAnnotation(
            com.ebmwebsourcing.easyschema10.api.element.Annotation annotation) {
        AnnotationImpl annotationImpl = (AnnotationImpl) annotation;
        getModelObject().setAnnotation(annotationImpl.getModelObject());
    }

    @Override
    public final void setId(String id) {
        getModelObject().setId(id);
    }
    
}
