package com.ebmwebsourcing.easyschema10.impl;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easyschema10.api.type.Facet;

import easybox.org.w3._2001.xmlschema.EJaxbFacet;

abstract class AbstractFacetImpl extends AbstractAnnotatedImpl<EJaxbFacet> implements Facet {

    protected AbstractFacetImpl(XmlContext xmlContext, EJaxbFacet jaxbModel) {
        super(xmlContext, jaxbModel);
    }

    @Override
    protected Class<? extends EJaxbFacet> getCompliantModelClass() {
        return EJaxbFacet.class;
    }

    
    @Override
    public final String getValue() {
        return getModelObject().getValue();
    }

    @Override
    public void setValue(String value) {
        getModelObject().setValue(value);
    }


}
