package com.ebmwebsourcing.easyschema10.impl;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easyschema10.api.element.Restriction;
import com.ebmwebsourcing.easyschema10.api.element.SimpleContent;
import com.ebmwebsourcing.easyschema10.api.type.ExtensionType;

import easybox.org.w3._2001.xmlschema.EJaxbSimpleContent;

final class SimpleContentImpl extends AbstractAnnotatedImpl<EJaxbSimpleContent> implements
        SimpleContent {

    protected SimpleContentImpl(XmlContext xmlContext, EJaxbSimpleContent jaxbModel) {
        super(xmlContext, jaxbModel);
    }


    @Override
    protected Class<? extends EJaxbSimpleContent> getCompliantModelClass() {
        return EJaxbSimpleContent.class;
    }
    
    @Override
    public ExtensionType getExtension() {
        return getXmlContext().getXmlObjectFactory().wrap(getModelObject().getExtension(),
                ExtensionTypeImpl.class);
    }

    @Override
    public Restriction getRestriction() {
        return getXmlContext().getXmlObjectFactory().wrap(getModelObject().getRestriction(),
                RestrictionImpl.class);
    }

    @Override
    public boolean hasExtension() {
        return getModelObject().getExtension() != null;
    }

    @Override
    public boolean hasRestriction() {
        return getModelObject().getRestriction() != null;
    }

}
