/****************************************************************************
 * Copyright (c) 2009-2012, EBM WebSourcing - All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ****************************************************************************/
 
package com.ebmwebsourcing.easyschema10.impl;

import java.util.Arrays;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.impl.AbstractJaxbModelObject;
import com.ebmwebsourcing.easybox.impl.JaxbDuplicator;
import com.ebmwebsourcing.easyschema10.api.element.All;
import com.ebmwebsourcing.easyschema10.api.element.Attribute;
import com.ebmwebsourcing.easyschema10.api.element.AttributeGroup;
import com.ebmwebsourcing.easyschema10.api.element.Choice;
import com.ebmwebsourcing.easyschema10.api.element.ComplexContent;
import com.ebmwebsourcing.easyschema10.api.element.Group;
import com.ebmwebsourcing.easyschema10.api.element.Schema;
import com.ebmwebsourcing.easyschema10.api.element.Sequence;
import com.ebmwebsourcing.easyschema10.api.element.SimpleContent;

import easybox.org.w3._2001.xmlschema.EJaxbAttribute;
import easybox.org.w3._2001.xmlschema.EJaxbAttributeGroup;
import easybox.org.w3._2001.xmlschema.EJaxbComplexType;
import easybox.org.w3._2001.xmlschema.EJaxbGroupRef;
import easybox.org.w3._2001.xmlschema.EJaxbLocalComplexType;
import easybox.org.w3._2001.xmlschema.EJaxbTopLevelComplexType;

final class ComplexTypeImpl extends AbstractTypeImpl<EJaxbComplexType> implements
com.ebmwebsourcing.easyschema10.api.element.ComplexType {

	protected ComplexTypeImpl(XmlContext xmlContext, EJaxbComplexType jaxbModel) {
		super(xmlContext, jaxbModel);
	}

	@Override
	protected Class<? extends EJaxbComplexType> getCompliantModelClass() {
		if (getXmlObjectParent() == null) {
			return EJaxbTopLevelComplexType.class;
		} else if (getXmlObjectParent() instanceof Schema) {
			return EJaxbTopLevelComplexType.class;
		} else {
			return EJaxbLocalComplexType.class;
		}
	}


	@Override
	public void addAttribute(Attribute attribute) {
		addToChildren(getModelObject().getAttributeOrAttributeGroup(),
				(AttributeImpl) attribute);
	}

	@Override
	public void addAttributeGroup(
			com.ebmwebsourcing.easyschema10.api.element.AttributeGroup attributeGroup) {
		addToChildren(getModelObject().getAttributeOrAttributeGroup(),
				(AttributeGroupImpl) attributeGroup);
	}

	@Override
	public void clearAttributeGroups() {
		clearChildren(getModelObject().getAttributeOrAttributeGroup(),
				EJaxbAttributeGroup.class, ANY_QNAME);
	}

	@Override
	public void clearAttributes() {
		clearChildren(getModelObject().getAttributeOrAttributeGroup(),
				EJaxbAttribute.class, ANY_QNAME);
	}

	@Override
	public All getAll() {
		if (!hasAll())
			return null;
		return getXmlContext().getXmlObjectFactory().wrap(getModelObject().getAll(),
				AllImpl.class);
	}

	@Override
	public Attribute getAttributeByName(String name) {
		return getChildByName(getAttributes(), name);
	}

	@Override
	public AttributeGroup getAttributeGroupByName(String name) {
		return getChildByName(getAttributeGroups(), name);
	}

	@Override
	public com.ebmwebsourcing.easyschema10.api.element.AttributeGroup[] getAttributeGroups() {
		return createChildrenArray(getModelObject()
				.getAttributeOrAttributeGroup(), EJaxbAttributeGroup.class, ANY_QNAME, 
				AttributeGroup.class);
	}

	@Override
	public Attribute[] getAttributes() {
		return createChildrenArray(getModelObject()
				.getAttributeOrAttributeGroup(), EJaxbAttribute.class, ANY_QNAME, 
				Attribute.class);
	}

	@Override
	public String[] getBlock() {
		if (!hasBlock())
			return null;
		return getModelObject().getBlock().toArray(
				new String[getModelObject().getBlock().size()]);
	}

	@Override
	public Choice getChoice() {
		if (!hasChoice())
			return null;
		return getXmlContext().getXmlObjectFactory().wrap(getModelObject().getChoice(),
				ChoiceImpl.class);
	}

	@Override
	public ComplexContent getComplexContent() {
		if (!hasComplexContent())
			return null;
		return getXmlContext().getXmlObjectFactory().wrap(
				getModelObject().getComplexContent(), ComplexContentImpl.class);
	}

	@Override
	public String[] getFinal() {
		if (!hasFinal())
			return null;
		return getModelObject().getFinal().toArray(
				new String[getModelObject().getFinal().size()]);
	}

	@Override
	public Group getGroup() {
		if (!hasGroup())
			return null;
		return getXmlContext().getXmlObjectFactory().wrap(getModelObject().getGroup(),
				GroupImpl.class);
	}

	@Override
	public String getName() {
		return getModelObject().getName();
	}

	@Override
	public Sequence getSequence() {
		if (!hasSequence())
			return null;
		return getXmlContext().getXmlObjectFactory().wrap(getModelObject().getSequence(),
				SequenceImpl.class);
	}

	@Override
	public SimpleContent getSimpleContent() {
		if (!hasSimpleContent())
			return null;
		return getXmlContext().getXmlObjectFactory().wrap(
				getModelObject().getSimpleContent(), SimpleContentImpl.class);
	}

	@Override
	public boolean hasAll() {
		return getModelObject().getAll() != null;
	}

	@Override
	public boolean hasBlock() {
		return getModelObject().isSetBlock();
	}

	@Override
	public boolean hasChoice() {
		return getModelObject().getChoice() != null;
	}

	@Override
	public boolean hasComplexContent() {
		return getModelObject().getComplexContent() != null;
	}

	@Override
	public boolean hasFinal() {
		return getModelObject().isSetFinal();
	}

	@Override
	public boolean hasGroup() {
		return getModelObject().getGroup() != null;
	}

	@Override
	public boolean hasName() {
		return getModelObject().getName() != null;
	}

	@Override
	public boolean hasSequence() {
		return getModelObject().getSequence() != null;
	}

	@Override
	public boolean hasSimpleContent() {
		return getModelObject().getSimpleContent() != null;
	}

	@Override
	public boolean isAbstract() {
		return getModelObject().isAbstract();
	}

	@Override
	public boolean isMixed() {
		return getModelObject().isMixed();
	}

	@Override
	public void removeAttribute(Attribute attribute) {
		removeFromChildren(getModelObject().getAttributeOrAttributeGroup(),
				(AttributeImpl) attribute);
	}

	@Override
	public void removeAttributeGroup(
			com.ebmwebsourcing.easyschema10.api.element.AttributeGroup attributeGroup) {
		removeFromChildren(getModelObject().getAttributeOrAttributeGroup(),
				(AttributeGroupImpl) attributeGroup);
	}

	@Override
	public void setAbstract(boolean isAbstract) {
		getModelObject().setAbstract(isAbstract);
	}

	@Override
	public void setAll(All all) {
		if(all != null) {
			getModelObject().setAll(((AllImpl) all).getModelObject());
		} else {
			getModelObject().setAll(null);
		}
	}

	@Override
	public void setBlock(String[] blockStrings) {
		getModelObject().unsetBlock();
		if (blockStrings != null) {
			getModelObject().getBlock().addAll(Arrays.asList(blockStrings));
		}
	}

	@Override
	public void setChoice(Choice choice) {
	    if (choice == null) {
	        getModelObject().setChoice(null);
	        return;
	    }
		getModelObject().setChoice(((ChoiceImpl) choice).getModelObject());
	}

	@Override
	public void setComplexContent(ComplexContent complexContent) {
	    if (complexContent == null) {
	        getModelObject().setComplexContent(null);
	        return;
	    }
		getModelObject().setComplexContent(
				((ComplexContentImpl) complexContent).getModelObject());
	}

	@Override
	public void setFinal(String[] finalStrings) {
		getModelObject().unsetFinal();
		if (finalStrings != null) {
			getModelObject().getFinal().addAll(Arrays.asList(finalStrings));
		}
	}

	@Override
	public void setGroup(Group group) {
	    if (group == null) {
	        getModelObject().setGroup(null);
	        return;
	    }
		assert group instanceof GroupImpl;
		getModelObject().setGroup(
		        JaxbDuplicator.duplicateAs(
						(AbstractJaxbModelObject) ((GroupImpl) group)
						.getModelObject(), EJaxbGroupRef.class));
	}

	@Override
	public void setMixed(boolean mixed) {
		getModelObject().setMixed(mixed);
	}

	@Override
	public void setName(String name) {
		getModelObject().setName(name);
	}

	@Override
	public void setSequence(Sequence sequence) {
		if(sequence != null) {
			getModelObject().setSequence(((SequenceImpl) sequence).getModelObject());
		} else {
			getModelObject().setSequence(null);
		}
	}

	
	@Override
	public void setSimpleContent(SimpleContent simpleContent) {
	    if (simpleContent == null) {
	        getModelObject().setSimpleContent(null);
	        return;
	    }
		getModelObject().setSimpleContent(
				((SimpleContentImpl) simpleContent).getModelObject());
	}


}
