package org.petalslink.abslayer;

import java.net.URI;
import java.net.URISyntaxException;

/**
 * Constants for WSDL version.
 */
public enum WSDLVersionConstants {

    WSDL11(Constants.WSDL_11_NAMESPACE), WSDL20(Constants.WSDL_20_NAMESPACE);

    /**
     * @param pattern
     * @return
     */
    public static WSDLVersionConstants valueOf(final URI pattern) {
        WSDLVersionConstants result = null;
        if (pattern != null) {
            for (final WSDLVersionConstants version : WSDLVersionConstants
                    .values()) {
                if (version.nameSpace.equals(pattern.toString())) {
                    result = version;
                }
            }
        }
        return result;
    }

    private final String nameSpace;

    private final URI version;

    /**
     * Creates a new instance of {@link WSDLVersionConstants}
     * 
     * @param nameSpace
     */
    private WSDLVersionConstants(final String nameSpace) {
        this.nameSpace = nameSpace;
        if (this.nameSpace != null) {
            try {
                this.version = new URI(nameSpace);
            } catch (final URISyntaxException e) {
                throw new Error("Unexpected Error in URI namespace syntax", e);
            }
        } else {
            this.version = null;
        }
    }

    /**
     * @return
     */
    public URI value() {
        return this.version;
    }

    /**
     * Please use this equals method instead of using :<code>
     * value().equals(mep)
     * </code> which is almost 10 times slower...
     * 
     * @param mep
     * @return
     */
    public boolean equals(final URI version) {
        return this.toString().equals(version.toString());
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Enum#toString()
     */
    @Override
    public String toString() {
        return this.nameSpace;
    }

}