package org.petalslink.abslayer.service.impl.wsdl11;

import javax.xml.namespace.QName;

import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Part;

public class MessageImpl implements org.petalslink.abslayer.service.api.Message {

    private final com.ebmwebsourcing.easywsdl11.api.element.Message model;

    private Part[] parts;

    private MessageImpl(com.ebmwebsourcing.easywsdl11.api.element.Message model) {
        this.model = model;
    }

    @Override
    public Part getPart(QName qname) {
        com.ebmwebsourcing.easywsdl11.api.element.Part p = model
                .getPartByName(qname.getLocalPart());
        if (p == null)
            return null;
        return (org.petalslink.abslayer.service.api.Part) Factory.getInstance().wrap(p);
    }

    @Override
    public Part[] getParts() {
        // TODO: urk should not access parts from here; should not access
        // message at all (wsdl11 specific).
        if (parts == null) {
            com.ebmwebsourcing.easywsdl11.api.element.Part[] messageParts = model
                    .getParts();
            parts = new Part[messageParts.length];
            int i = 0;
            for (com.ebmwebsourcing.easywsdl11.api.element.Part part : messageParts) {
                parts[i] = (org.petalslink.abslayer.service.api.Part) Factory.getInstance().wrap(part);
            }
        }
        return parts;
    }

}
