package org.petalslink.abslayer.service.impl.wsdl11;

import java.util.ArrayList;
import java.util.List;

import javax.xml.namespace.QName;

import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.PartnerLinkType;
import org.petalslink.abslayer.service.api.Role;

public class PartnerLinkTypeImpl implements PartnerLinkType {

    private com.ebmwebsourcing.easyplnk20.api.element.PartnerLinkType model;

    private PartnerLinkTypeImpl(
            com.ebmwebsourcing.easyplnk20.api.element.PartnerLinkType model) {
        this.model = model;
    }

    @Override
    public Role getRole(String partnerRole) {
        com.ebmwebsourcing.easyplnk20.api.element.Role role = model
                .getRoleByName(partnerRole);
        if (role == null)
            return null;
        return (org.petalslink.abslayer.service.api.Role) Factory.getInstance().wrap(role);
    }

    @Override
    public List<Role> getRoles() {
        com.ebmwebsourcing.easyplnk20.api.element.Role[] modelRoles = model
                .getRoles();
        List<Role> roles = new ArrayList<Role>();
        for (com.ebmwebsourcing.easyplnk20.api.element.Role role : modelRoles) {
            roles.add((org.petalslink.abslayer.service.api.Role) Factory.getInstance().wrap(role));
        }
        return roles;
    }

    @Override
    public QName getQName() {
        throw new UnsupportedOperationException();
    }

}
