package org.petalslink.abslayer.service.impl.wsdl11;

import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Description;

import com.ebmwebsourcing.easywsdl11.api.element.Definitions;

public class ImportImpl implements org.petalslink.abslayer.service.api.Import {

    private final com.ebmwebsourcing.easywsdl11.api.element.Import model;

    
    private ImportImpl(com.ebmwebsourcing.easywsdl11.api.element.Import model) {
    	this.model = model;
    }
    
	@Override
	public Description getParentDescription() {
		if(this.model.getXmlObjectRoot() == null) {
			return null;
		}
		return (Description) Factory.getInstance().wrap(this.model.getXmlObjectBaseRoot());
	}

	@Override
	public String getNamespace() {
		return this.model.getNamespace();
	}

	@Override
	public String getLocation() {
		return this.model.getLocation();
	}

	@Override
	public Description getImportDescription(){
		Definitions def = (Definitions) model.getXmlObjectAdoptedChildren()[0];
		if(def != null){
			return (Description) Factory.getInstance().wrap(def);
		} else {
			return null;
		}
	}

}
