package org.petalslink.abslayer.service.impl.wsdl11;

import javax.xml.namespace.QName;

import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Part;

import com.ebmwebsourcing.easywsdl11.api.element.Message;

public class InputImpl implements org.petalslink.abslayer.service.api.Input {

    private final com.ebmwebsourcing.easywsdl11.api.element.Input model;

    private Part[] parts;

    private InputImpl(com.ebmwebsourcing.easywsdl11.api.element.Input model) {
        this.model = model;
    }

    @Override
    public QName getMessageName() {
        return model.getMessage();
    }

    @Override
    public Part[] getParts() {
        // TODO: urk should not access parts from here; should not access parts
        // at all (wsdl11 specific).
        if (parts == null) {
            Message message = model.findMessage();
            assert message != null;
            com.ebmwebsourcing.easywsdl11.api.element.Part[] messageParts = message
                    .getParts();
            parts = new Part[messageParts.length];
            int i = 0;
            for (com.ebmwebsourcing.easywsdl11.api.element.Part part : messageParts) {
                parts[i] = (org.petalslink.abslayer.service.api.Part) Factory.getInstance().wrap(part);
            }
        }
        return parts;
    }

    public com.ebmwebsourcing.easyschema10.api.element.Element getElement() {
        Part[] parts = getParts();
        if (parts.length > 0)
            return parts[0].getElement();
        return null;
    }

}
