/****************************************************************************
 *
 * Copyright (c) 2010-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/

package org.petalslink.abslayer.service.impl.wsdl11;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easywsdl11.api.element.Message;
import com.ebmwebsourcing.easywsdl11.api.element.Part;
import org.petalslink.abslayer.service.api.Element;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
public class FaultImpl implements org.petalslink.abslayer.service.api.Fault {

    private final com.ebmwebsourcing.easywsdl11.api.element.Fault model;

    private FaultImpl(com.ebmwebsourcing.easywsdl11.api.element.Fault model) {
        this.model = model;
    }

    @Override
    public String getName() {
        return model.getName();
    }

    @Override
    public QName getMessageName() {
        return model.getMessage();
    }

    @Override
    public QName getElementQName() {
        // TODO : not really fair I guess
        Message msg = model.findMessage();
        if (msg == null)
            return null;
        Part[] parts = msg.getParts();
        if (parts.length == 0)
            return null;
        return parts[0].getElement();
    }

    @Override
    public com.ebmwebsourcing.easyschema10.api.element.Element getMessage() {
        Message msg = model.findMessage();
        if(msg != null && msg.getParts().length>0){
            return msg.getParts()[0].findElement();
        }else{
              return null;
        }
    }
}
