/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.abslayer;

import java.net.URI;
import java.net.URISyntaxException;

public enum WSDLVersionConstants {
    WSDL11("http://schemas.xmlsoap.org/wsdl/"),
    WSDL20("http://www.w3.org/ns/wsdl");

    private final String nameSpace;
    private final URI version;

    public static WSDLVersionConstants valueOf(URI pattern) {
        WSDLVersionConstants result = null;
        if (pattern != null) {
            for (WSDLVersionConstants version : WSDLVersionConstants.values()) {
                if (!version.nameSpace.equals(pattern.toString())) continue;
                result = version;
            }
        }
        return result;
    }

    private WSDLVersionConstants(String nameSpace) {
        this.nameSpace = nameSpace;
        if (this.nameSpace != null) {
            try {
                this.version = new URI(nameSpace);
            }
            catch (URISyntaxException e) {
                throw new Error("Unexpected Error in URI namespace syntax", e);
            }
        } else {
            this.version = null;
        }
    }

    public URI value() {
        return this.version;
    }

    public boolean equals(URI version) {
        return this.toString().equals(version.toString());
    }

    public String toString() {
        return this.nameSpace;
    }
}

