/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.esstar.management;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import javax.activation.DataHandler;
import javax.activation.FileDataSource;
import javax.xml.namespace.QName;

import org.oasis_open.docs.wsn.bw_2.InvalidFilterFault;
import org.oasis_open.docs.wsn.bw_2.InvalidMessageContentExpressionFault;
import org.oasis_open.docs.wsn.bw_2.InvalidProducerPropertiesExpressionFault;
import org.oasis_open.docs.wsn.bw_2.InvalidTopicExpressionFault;
import org.oasis_open.docs.wsn.bw_2.NotifyMessageNotSupportedFault;
import org.oasis_open.docs.wsn.bw_2.SubscribeCreationFailedFault;
import org.oasis_open.docs.wsn.bw_2.TopicExpressionDialectUnknownFault;
import org.oasis_open.docs.wsn.bw_2.TopicNotSupportedFault;
import org.oasis_open.docs.wsn.bw_2.UnableToDestroySubscriptionFault;
import org.oasis_open.docs.wsn.bw_2.UnacceptableInitialTerminationTimeFault;
import org.oasis_open.docs.wsn.bw_2.UnrecognizedPolicyRequestFault;
import org.oasis_open.docs.wsn.bw_2.UnsupportedPolicyRequestFault;
import org.oasis_open.docs.wsrf.rpw_2.InvalidResourcePropertyQNameFault;
import org.oasis_open.docs.wsrf.rw_2.ResourceUnavailableFault;
import org.oasis_open.docs.wsrf.rw_2.ResourceUnknownFault;

import com.ebmwebsourcing.easycommons.research.util.cxf.CXFHelper;
import com.ebmwebsourcing.wsstar.jaxb.notification.base.Notify;
import com.ebmwebsourcing.wsstar.jaxb.notification.base.Subscribe;
import com.ebmwebsourcing.wsstar.jaxb.notification.base.SubscribeResponse;
import com.ebmwebsourcing.wsstar.jaxb.notification.base.Unsubscribe;
import com.ebmwebsourcing.wsstar.jaxb.notification.base.UnsubscribeResponse;
import com.ebmwebsourcing.wsstar.jaxb.resource.resourceproperties.GetResourcePropertyResponse;

import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeployementReport;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDescriptorType;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbLinkedResourceDescriptorType;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbWsdl;
import esstar.petalslink.com.data.management.user._1.Bind;
import esstar.petalslink.com.data.management.user._1.BindResponse;
import esstar.petalslink.com.data.management.user._1.Deploy;
import esstar.petalslink.com.data.management.user._1.DeployResponse;
import esstar.petalslink.com.data.management.user._1.Ping;
import esstar.petalslink.com.data.management.user._1.PingResponse;
import esstar.petalslink.com.data.management.user._1.Proxify;
import esstar.petalslink.com.data.management.user._1.ProxifyResponse;
import esstar.petalslink.com.service.management.user._1_0.PingFault;
import esstar.petalslink.com.service.management.user._1_0.UserManagement;
import esstar.petalslink.com.service.management.user._1_0.UserManagementException;

public class UserManagementClient implements UserManagement {

	protected String address = null;
	
	private UserManagement clientProxy;
	
	private static easybox.esstar.petalslink.com.management.model.datatype._1.ObjectFactory objectFactory = new easybox.esstar.petalslink.com.management.model.datatype._1.ObjectFactory();
	
	public UserManagementClient(String address) {
		this.address = address;
	}
	
	
    /**
     * @return the clientProxy
     */
    private synchronized UserManagement getClientProxy() {
        if (clientProxy != null) {
            return clientProxy;
        }
        this.clientProxy = CXFHelper.getClient(address, UserManagement.class);
        return clientProxy;
    }


	@Override
	public SubscribeResponse subscribe(Subscribe subscribeRequest)
			throws NotifyMessageNotSupportedFault, InvalidFilterFault,
			InvalidTopicExpressionFault, TopicExpressionDialectUnknownFault,
			UnsupportedPolicyRequestFault, SubscribeCreationFailedFault,
			UnacceptableInitialTerminationTimeFault,
			UnrecognizedPolicyRequestFault, TopicNotSupportedFault,
			InvalidProducerPropertiesExpressionFault, ResourceUnknownFault,
			InvalidMessageContentExpressionFault {
		return this.getClientProxy().subscribe(subscribeRequest);
	}


	@Override
	public UnsubscribeResponse unsubscribe(Unsubscribe unsubscribeRequest)
			throws UnableToDestroySubscriptionFault, ResourceUnknownFault {
		return this.getClientProxy().unsubscribe(unsubscribeRequest);
	}


	@Override
	public ProxifyResponse proxify(Proxify parameters)
			throws UserManagementException {
		return this.getClientProxy().proxify(parameters);
	}


	@Override
	public String expose(QName serviceName, String endpointName)
			throws UserManagementException {
		return this.getClientProxy().expose(serviceName, endpointName);
	}


	@Override
	public BindResponse bind(Bind parameters) throws UserManagementException {
		return this.getClientProxy().bind(parameters);
	}
	
	


	@Override
	public GetResourcePropertyResponse getResourceProperty(
			QName getResourcePropertyRequest) throws ResourceUnavailableFault,
			InvalidResourcePropertyQNameFault, ResourceUnknownFault {
		return this.getClientProxy().getResourceProperty(getResourcePropertyRequest);
	}


	@Override
	public DeployResponse deploy(Deploy parameters)
			throws UserManagementException {
		return this.getClientProxy().deploy(parameters);
	}
	
	public String bind(String externalAddres, String wsdlUrl) throws UserManagementException {
		Bind request = new Bind();
		request.setExternalAddress(externalAddres);
		EJaxbWsdl wsdl = new EJaxbWsdl();
		wsdl.setUrl(objectFactory.createEJaxbWsdlUrl(wsdlUrl));
		request.setWsdl(wsdl);
		BindResponse response = this.getClientProxy().bind(request);
		return response.getEndpointName();
	}

	public String proxify(String externalAddres, String wsdlUrl) throws UserManagementException {
		Proxify request = new Proxify();
		request.setExternalAddress(externalAddres);
		EJaxbWsdl wsdl = new EJaxbWsdl();
		wsdl.setUrl(objectFactory.createEJaxbWsdlUrl(wsdlUrl));
		request.setWsdl(wsdl);
		ProxifyResponse response = this.getClientProxy().proxify(request);
		return response.getExternalAddress();
	}
	
    /*
     * (non-Javadoc)
     * 
     * @see org.petalslink.dsb.ws.bpel.client.BPELDeployer#deploy(java.io.File,
     * java.io.File[])
     */
    public EJaxbDeployementReport deploy(File descriptorFile, File[] resources) throws UserManagementException {
        if (descriptorFile == null) {
            throw new UserManagementException("Descriptor file can not be null");
        }

        if (!descriptorFile.exists() || !descriptorFile.isFile()) {
            throw new UserManagementException("Descriptor file " +  descriptorFile.getName() + " does not exists or is not a file");
        }

        EJaxbDescriptorType descriptor = new EJaxbDescriptorType();
        descriptor.setFileURI(descriptorFile.toURI().toString());
        descriptor.setAttachment(new DataHandler(new FileDataSource(descriptorFile)));

        List<EJaxbLinkedResourceDescriptorType> list = new ArrayList<EJaxbLinkedResourceDescriptorType>();
        if (resources != null) {
            for (File file : resources) {
                if (file != null && file.exists() && file.isFile()) {
                	EJaxbLinkedResourceDescriptorType resource = new EJaxbLinkedResourceDescriptorType();
                    resource.setFileURI(file.toURI().toString());
                    resource.setResource(new DataHandler(new FileDataSource(file)));
                    list.add(resource);
                } else {
                    // warning
                }
            }
        }
        Deploy request = new Deploy();
        request.setArtifact(descriptor);
        request.getResources().addAll(list);
        DeployResponse response = deploy(request);
        return response.getDeployementReport();
    }


	@Override
	public void notify(Notify notify) {
		this.getClientProxy().notify(notify);
	}


	@Override
	public PingResponse ping(Ping parameters) throws PingFault {
		PingResponse res = new PingResponse();
		
		return this.getClientProxy().ping(parameters);
	}
}
