/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.esstar.management;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

import javax.activation.DataHandler;
import javax.activation.FileDataSource;
import javax.xml.namespace.QName;

import org.oasis_open.docs.wsn.bw_2.InvalidFilterFault;
import org.oasis_open.docs.wsn.bw_2.InvalidMessageContentExpressionFault;
import org.oasis_open.docs.wsn.bw_2.InvalidProducerPropertiesExpressionFault;
import org.oasis_open.docs.wsn.bw_2.InvalidTopicExpressionFault;
import org.oasis_open.docs.wsn.bw_2.NotifyMessageNotSupportedFault;
import org.oasis_open.docs.wsn.bw_2.SubscribeCreationFailedFault;
import org.oasis_open.docs.wsn.bw_2.TopicExpressionDialectUnknownFault;
import org.oasis_open.docs.wsn.bw_2.TopicNotSupportedFault;
import org.oasis_open.docs.wsn.bw_2.UnableToDestroySubscriptionFault;
import org.oasis_open.docs.wsn.bw_2.UnacceptableInitialTerminationTimeFault;
import org.oasis_open.docs.wsn.bw_2.UnrecognizedPolicyRequestFault;
import org.oasis_open.docs.wsn.bw_2.UnsupportedPolicyRequestFault;
import org.oasis_open.docs.wsrf.rpw_2.InvalidResourcePropertyQNameFault;
import org.oasis_open.docs.wsrf.rw_2.ResourceUnavailableFault;
import org.oasis_open.docs.wsrf.rw_2.ResourceUnknownFault;

import com.ebmwebsourcing.easycommons.research.util.cxf.CXFHelper;

import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeploy;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeployResponse;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeployementReport;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDescriptorType;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbUndeploy;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbUndeployResponse;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbNotify;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbSubscribe;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbSubscribeResponse;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbUnsubscribe;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbUnsubscribeResponse;
import easybox.org.oasis_open.docs.wsrf.rp_2.EJaxbGetResourcePropertyResponse;
import esstar.petalslink.com.data.management.admin._1.GetAdditionalContent;
import esstar.petalslink.com.data.management.admin._1.GetAdditionalContentResponse;
import esstar.petalslink.com.data.management.admin._1.GetContent;
import esstar.petalslink.com.data.management.admin._1.GetContentResponse;
import esstar.petalslink.com.data.management.admin._1.GetExecutionEnvironmentInformation;
import esstar.petalslink.com.data.management.admin._1.GetExecutionEnvironmentInformationResponse;
import esstar.petalslink.com.data.management.admin._1.GetResourceIdentifiers;
import esstar.petalslink.com.data.management.admin._1.GetResourceIdentifiersResponse;
import esstar.petalslink.com.service.management._1_0.ManagementException;
import esstar.petalslink.com.service.management.admin._1_0.AdminManagement;

public class AdminManagementClient implements AdminManagement {

	protected String address = null;
	

	private AdminManagement clientProxy;
	
	
	public AdminManagementClient(String address) {
		this.address = address;
	}
	
	
	public String getAddress() {
		return address;
	}
	
    /**
     * @return the clientProxy
     */
    private synchronized AdminManagement getClientProxy() {
        if (clientProxy != null) {
            return clientProxy;
        }
        this.clientProxy = CXFHelper.getClient(address, AdminManagement.class);
        return clientProxy;
    }


	@Override
	public EJaxbSubscribeResponse subscribe(EJaxbSubscribe subscribeRequest)
			throws NotifyMessageNotSupportedFault, InvalidFilterFault,
			InvalidTopicExpressionFault, TopicExpressionDialectUnknownFault,
			UnsupportedPolicyRequestFault, SubscribeCreationFailedFault,
			UnacceptableInitialTerminationTimeFault,
			UnrecognizedPolicyRequestFault, TopicNotSupportedFault,
			InvalidProducerPropertiesExpressionFault, ResourceUnknownFault,
			InvalidMessageContentExpressionFault {
		return this.getClientProxy().subscribe(subscribeRequest);
	}


	@Override
	public EJaxbUnsubscribeResponse unsubscribe(EJaxbUnsubscribe unsubscribeRequest)
			throws UnableToDestroySubscriptionFault, ResourceUnknownFault {
		return this.getClientProxy().unsubscribe(unsubscribeRequest);
	}


	@Override
	public EJaxbGetResourcePropertyResponse getResourceProperty(
			QName getResourcePropertyRequest) throws ResourceUnavailableFault,
			InvalidResourcePropertyQNameFault, ResourceUnknownFault {
		return this.getClientProxy().getResourceProperty(getResourcePropertyRequest);
	}


	@Override
	public EJaxbDeployResponse deploy(
			EJaxbDeploy parameters)
			throws ManagementException {
		return this.getClientProxy().deploy(parameters);
	}


	@Override
	public void stop() {
		this.getClientProxy().stop();
	}
	
	@Override
	public GetExecutionEnvironmentInformationResponse getExecutionEnvironmentInformation(
			GetExecutionEnvironmentInformation parameters)
			throws ManagementException {
		return this.getClientProxy().getExecutionEnvironmentInformation(parameters);
	}


	@Override
	public GetResourceIdentifiersResponse getResourceIdentifiers(
			GetResourceIdentifiers parameters) throws ManagementException {
		return this.getClientProxy().getResourceIdentifiers(parameters);
	}


	@Override
	public GetAdditionalContentResponse getAdditionalContent(
			GetAdditionalContent getAdditionalContentRequest)
			throws ManagementException {
		return this.getClientProxy().getAdditionalContent(getAdditionalContentRequest);
	}


	@Override
	public GetContentResponse getContent(GetContent parameters)
			throws ManagementException {
		return this.getClientProxy().getContent(parameters);
	}

	
	public EJaxbDeployementReport deploy(URL descriptorURL) throws ManagementException {
		if (descriptorURL == null) {
            throw new ManagementException("Descriptor file can not be null");
        }


        EJaxbDescriptorType descriptor = new EJaxbDescriptorType();
        descriptor.setFileURI(descriptorURL.toString());
       
        EJaxbDeploy request = new EJaxbDeploy();
        request.setMainResource(descriptor);
        EJaxbDeployResponse response = deploy(request);
        return response.getDeployementReport();
	}
	
	/*
     * (non-Javadoc)
     * 
     * @see org.petalslink.dsb.ws.bpel.client.BPELDeployer#deploy(java.io.File,
     * java.io.File[])
     */
    public EJaxbDeployementReport deploy(File descriptorFile, File[] resources) throws ManagementException {
        if (descriptorFile == null) {
            throw new ManagementException("Descriptor file can not be null");
        }

        if (!descriptorFile.exists() || !descriptorFile.isFile()) {
            throw new ManagementException("Descriptor file " +  descriptorFile.getName() + " does not exists or is not a file");
        }

        EJaxbDescriptorType descriptor = new EJaxbDescriptorType();
        descriptor.setFileURI(descriptorFile.toURI().toString());
        descriptor.setAttachment(new DataHandler(new FileDataSource(descriptorFile)));

        List<EJaxbDescriptorType> list = new ArrayList<EJaxbDescriptorType>();
        if (resources != null) {
            for (File file : resources) {
                if (file != null && file.exists() && file.isFile()) {
                	EJaxbDescriptorType resource = new EJaxbDescriptorType();
                    resource.setFileURI(file.toURI().toString());
                    resource.setAttachment(new DataHandler(new FileDataSource(file)));
                    list.add(resource);
                } else {
                    // warning
                }
            }
        }
        EJaxbDeploy request = new EJaxbDeploy();
        request.setMainResource(descriptor);
        request.getResources().addAll(list);
        EJaxbDeployResponse response = deploy(request);
        return response.getDeployementReport();
    }


	@Override
	public void notify(EJaxbNotify notify) {
		this.getClientProxy().notify(notify);
	}


	@Override
	public void unconnectToGovernance(String address)
			throws ManagementException {
		this.getClientProxy().unconnectToGovernance(address);
	}


	@Override
	public void connectToGovernance(String address)
			throws ManagementException {
		this.getClientProxy().connectToGovernance(address);
	}


	@Override
	public EJaxbUndeployResponse undeploy(EJaxbUndeploy parameters)
			throws ManagementException {
		return this.getClientProxy().undeploy(parameters);
	}


}
