/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.esstar.essynchronizer.impl.thread;

import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.esstar.management.AdminManagementClientSOAP;
import com.petalslink.esstar.essynchronizer.impl.AbstractResourcesManager;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbResourceIdentifier;
import esstar.petalslink.com.data.management.admin._1.GetContent;
import esstar.petalslink.com.data.management.admin._1.GetContentResponse;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ResourceIdSynchronizerThread
extends Thread {
    private List<EJaxbResourceIdentifier> rids = null;
    private String address = null;
    private AdminManagementClientSOAP client = null;
    private AbstractResourcesManager manager = null;

    public ResourceIdSynchronizerThread(List<EJaxbResourceIdentifier> rids, String address, AdminManagementClientSOAP client, AbstractResourcesManager manager) throws SOAException {
        this.rids = rids;
        this.address = address;
        this.manager = manager;
        this.client = client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        for (EJaxbResourceIdentifier rid : this.rids) {
            GetContent payload = new GetContent();
            payload.setResourceIdentifier(rid);
            try {
                Document doc = null;
                HashMap<String, Object> metadata = new HashMap<String, Object>();
                AdminManagementClientSOAP adminManagementClientSOAP = this.client;
                synchronized (adminManagementClientSOAP) {
                    GetContentResponse response = this.client.getContent(payload);
                    doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
                    doc.appendChild(doc.importNode((Element)response.getAny(), true));
                    metadata.put("address", this.address);
                    metadata.put("resourceId", rid.getId());
                    System.out.println("content: \n" + XMLPrettyPrinter.prettyPrint((Document)doc));
                    this.manager.analyzeResourceContent(rid, doc, metadata);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }
}

