package com.petalslink.esstar.essynchronizer.impl.thread;

import java.util.List;

import com.ebmwebsourcing.esstar.management.AdminManagementClient;
import com.ebmwebsourcing.esstar.management.AdminManagementClientSOAP;
import com.petalslink.esstar.essynchronizer.impl.AbstractResourcesManager;

import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbResourceIdentifier;

public class ResourceIdListSynchronizerThread extends Thread {

	public static int MAX_NUMBER_OF_RESOURCES = 10;

	private List<EJaxbResourceIdentifier> rids = null;

	private String address = null;
	
	private AbstractResourcesManager manager = null;
	
	private AdminManagementClientSOAP client = null;

	public ResourceIdListSynchronizerThread(List<EJaxbResourceIdentifier> rids, String address, AdminManagementClientSOAP client, AbstractResourcesManager manager) {
		this.rids = rids;
		this.address = address;
		this.manager = manager;
		this.client = client;
	}

	@Override
	public void run() {
		try {
			if(rids.size() > MAX_NUMBER_OF_RESOURCES) {
				int fromIndex = 0;
				int toIndex = MAX_NUMBER_OF_RESOURCES;
				List<EJaxbResourceIdentifier> subList = this.rids.subList(fromIndex, toIndex);
				while(toIndex < this.rids.size()) {
					ResourceIdSynchronizerThread synchro = new ResourceIdSynchronizerThread(subList, address, this.client, this.manager);
					synchro.start();
					fromIndex = fromIndex + MAX_NUMBER_OF_RESOURCES;
					toIndex = toIndex + MAX_NUMBER_OF_RESOURCES;
					subList = this.rids.subList(fromIndex, toIndex);
				}
				if(toIndex > this.rids.size()) {
					subList = this.rids.subList(fromIndex, this.rids.size());
					ResourceIdSynchronizerThread synchro = new ResourceIdSynchronizerThread(this.rids, address, this.client, this.manager);
					synchro.start();
				}
			} else {
				ResourceIdSynchronizerThread synchro;
				synchro = new ResourceIdSynchronizerThread(this.rids, address, this.client, this.manager);
				synchro.run();
			}
		} catch (Throwable e) {
			// Do nothing
			e.printStackTrace();
		}
	}


}
