package com.petalslink.esstar.essynchronizer.impl.thread;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.esstar.management.AdminManagementClientSOAP;
import com.petalslink.esstar.essynchronizer.impl.AbstractResourcesManager;

import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbResourceIdentifier;
import esstar.petalslink.com.data.management.admin._1.GetContent;
import esstar.petalslink.com.data.management.admin._1.GetContentResponse;

public class ResourceIdSynchronizerThread extends Thread {

	private static Logger LOG = Logger.getLogger(ResourceIdSynchronizerThread.class.getName());

	private List<EJaxbResourceIdentifier> rids = null;

	private String address = null;

	private AdminManagementClientSOAP client = null;


	private AbstractResourcesManager manager = null;

	public ResourceIdSynchronizerThread(List<EJaxbResourceIdentifier> rids, String address, AdminManagementClientSOAP client, AbstractResourcesManager manager) throws SOAException {
		this.rids = rids;
		this.address = address;
		this.manager = manager;
		this.client = client;
	}

	@Override
	public void run() {
		for(EJaxbResourceIdentifier rid: this.rids) {
			GetContent payload = new GetContent();
			payload.setResourceIdentifier(rid);
			try {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				Map<String, Object> metadata = new HashMap<String, Object>();
				synchronized(client) {
					//                    client.setAddress(address);
					GetContentResponse response = client.getContent(payload);

					if(response.getAny() instanceof org.w3c.dom.Element){

						doc.appendChild(doc.importNode((Element)response.getAny(), true));

					}else if(response.getAny() instanceof easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeployementReport){
						easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeployementReport depReport = (easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeployementReport) response.getAny(); 
						Document anyAsDoc = SOAJAXBContext.getInstance().unmarshallAnyElement(depReport);
						Node firstchild = doc.adoptNode(anyAsDoc.getFirstChild());
						doc.appendChild(doc.importNode(firstchild, true));
					}
					metadata.put("address", this.address);
					metadata.put("resourceId", rid.getId());

					if(Level.FINEST.equals(LOG.getLevel())){
						LOG.finest("content: \n" + XMLPrettyPrinter.prettyPrint(doc));
					}

					this.manager.analyzeResourceContent(rid, doc, metadata);
				}
			} catch (Throwable e) {
				// Do nothing
				e.printStackTrace();
			} 
		}
	}


}
