package com.ebmwebsourcing.esstar.essynchronizer.generic.notifier.client;

import javax.xml.namespace.QName;

import org.ow2.petals.notifier.NotifierServerInterface;
import org.ow2.petals.notifier.SubscribeOnFault;
import org.ow2.petals.notifier.data.SubscribeOn;
import org.ow2.petals.notifier.data.SubscribeOnResponse;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPHandler;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPSender;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;

import easybox.org.oasis_open.docs.wsn.b_2.EJaxbNotify;

public class NotifierClientSOAP implements NotifierServerInterface {

	
	protected String address = null;

	private SOAPSender soapSender;

	static{
		try {
			SOAJAXBContext.getInstance().addOtherObjectFactory(
					easybox.org.oasis_open.docs.wsn.b_2.ObjectFactory.class,
					org.ow2.petals.notifier.data.ObjectFactory.class);
		} catch (SOAException e) {
			// do nothing
			e.printStackTrace();
		}
	}
	
	public NotifierClientSOAP(String address) {
		this.soapSender = new SOAPSender();
		this.address = address;
	}
	
	@Override
	public void notify(EJaxbNotify notify) {
		try{
			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(notify));
			soapSender.sendSoapRequest(soapRequest, address, "http://petals.ow2.org/notifier/Notify");

		} catch (Exception e) {
			// do nothing;
		} 
	}

	@Override
	public String subscribeOn(String producer, QName topic)
			throws SubscribeOnFault {
		SubscribeOnResponse res = null;
		try{
			SubscribeOn request = new SubscribeOn();
			request.setProducer(producer);
			request.setTopic(topic);

			Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(request));
			Document soapResponse = soapSender.sendSoapRequest(soapRequest, address, "http://petals.ow2.org/notifier/SubscribeOn");
			if(SOAPHandler.isSoapFault(soapResponse)) {
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				if(SOAPHandler.getFaultDetails(soapResponse).size() > 0) {
					doc.appendChild((Element)doc.importNode((Element) SOAPHandler.getFaultDetails(soapResponse).get(0), true).cloneNode(true));
					throw new SubscribeOnFault("Business Fault: " + XMLPrettyPrinter.prettyPrint(doc));
				} else {
					throw new SubscribeOnFault("Technical Fault: \n" + XMLPrettyPrinter.prettyPrint(soapResponse));
				}
			}

			// get bpel store response
			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
			res = SOAJAXBContext.getInstance().marshallAnyType(doc, SubscribeOnResponse.class);
		} catch (Exception e) {
			throw new SubscribeOnFault("Technical Fault", e);
		} 

		return res.getOut();
	}

}
