/**
 * Raphael Diagram - A crossbrowser SVG/VML library creating diagrams - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.gwt.raphael.client.diagram.connector;

import java.util.ArrayList;

import com.ebmwebsourcing.gwt.raphael.client.diagram.element.DiagramElement;
import com.ebmwebsourcing.gwt.raphael.client.diagram.event.DiagramElementDragListenerAdapter;
import com.ebmwebsourcing.gwt.raphael.client.diagram.event.DiagramElementDropListenerAdapter;
import com.ebmwebsourcing.gwt.raphael.client.diagram.event.DiagramElementListenerAdapter;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DeferredCommand;
import com.ebmwebsourcing.gwt.raphael.client.diagram.event.HideEvent;
import com.ebmwebsourcing.gwt.raphael.client.diagram.event.HideHandler;
import com.ebmwebsourcing.gwt.raphael.client.diagram.event.ShowEvent;
import com.ebmwebsourcing.gwt.raphael.client.diagram.event.ShowHandler;


/**
 * 
 * @author nfleury
 *
 */
public class Connectable implements HideHandler, ShowHandler{

	
	private DiagramElement connectableElement;
	
	private MagnetDisposition magnetDisposition 				= MagnetDisposition.All;
	
	private ArrayList<ConnectorExtremity> connectorExtremities 	= new ArrayList<ConnectorExtremity>();
	
	
	//////Magnets
	
    //top left Magnet
    private Magnet tLMagnet;
    
    //top middle Magnet
    private Magnet tMMagnet;
    
    //top right Magnet
    private Magnet tRMagnet;
    
    //left middle Magnet
    private Magnet lMMagnet;
    
    //bottom left Magnet
    private Magnet bLMagnet;
    
    //bottom middle Magnet
    private Magnet bMMagnet;
    
    //bottom right Magnet
    private Magnet bRMagnet;
    
    //right middle Magnet
    private Magnet rMMagnet;
	
    //Previous magnets that are actually added around the connectable element
    private ArrayList<Magnet> actualMagnets = new ArrayList<Magnet>();
    
    private boolean connectableElementIsLoaded = false;
	
	public Connectable(DiagramElement connectableElement,MagnetDisposition magnetDisposition) {
		
		this.connectableElement 	= connectableElement;
		this.magnetDisposition 		= magnetDisposition;
		connectableElement.addShowHandler(this);
		connectableElement.addHideHandler(this);
	
		this.initializeMagnets();
		
		
	}
	
	public Connectable(DiagramElement diagramElement) {
		this(diagramElement, MagnetDisposition.All);
	}
	
	
	public void initializeMagnets(){
		
		
		if (connectableElement.isLoaded()){
			
			attachMagnetsToConnectableElement();
			
		}
		
		connectableElement.isDroppable(true);
		connectableElement.addDropListener(new DiagramElementDropListenerAdapter(){
			
			@Override
			public void onOver(DiagramElement diagramElement,
					DiagramElement overElement) {
			
				if ( overElement instanceof ConnectorExtremity){
					
					for(Magnet magnet : actualMagnets){
						magnet.show();
					}
					
				}
				
			}
			
			@Override
			public void onOut(DiagramElement targetElement,
					DiagramElement outElement) {
				
				if ( outElement instanceof ConnectorExtremity){
					
					for(Magnet magnet : actualMagnets){
						magnet.hide();
					}					
				}

				
				
			}
			
			@Override
			public void onDrop(DiagramElement targetElement,
					DiagramElement droppedElement) {
				for (Magnet magnet : actualMagnets){
					magnet.hide();
				}
				
				//Connect by the closest point
				if (droppedElement instanceof ConnectorBeginPoint){
					
					ConnectorBeginPoint bP = (ConnectorBeginPoint) droppedElement;
					//connectable is connected on the other side
					if (bP.getConnector().getSource()!=null){
						
						
						bP.getConnector().connect(bP.getConnector().getSource(), Connectable.this);
						
					}
					
					
					
				}else if(droppedElement instanceof ConnectorEndPoint){
					
					
					ConnectorEndPoint eP = (ConnectorEndPoint) droppedElement;
					//connectable is connected on the other side
					if (eP.getConnector().getTarget()!=null){
						
						
						eP.getConnector().connect( Connectable.this,eP.getConnector().getTarget());
						
					}					
					
					
				}
				
				
				
			}
			
		});
		

		connectableElement.addDragListener(new DiagramElementDragListenerAdapter(){

			//Move the connector extremity along with magnet of current connectable
			@Override
			public void onDrag(DiagramElement diagramElement) {
					
				refreshMagnetsPosition();
				
				refreshConnectedConnectors();
	
			}
			
			
			@Override
			public void onStop(DiagramElement diagramElement) {
				
				DeferredCommand.addCommand(new Command(){
					public void execute() {
						
						
					refreshMagnetsPosition();
					
					refreshConnectedConnectors();
					

						
							//always connect by closest magnets when connectable is connected both way
							for(DiagramConnector connector: getIncommingConnectors()){
								
								if (connector.getSource()!=null && connector.getTarget()!=null) connector.connect(connector.getSource(), connector.getTarget()); 
								
							}

							//always connect by closest magnets when connectable is connected both way
							for(DiagramConnector connector: getOutgoingConnectors()	){
								
								if (connector.getSource()!=null && connector.getTarget()!=null) connector.connect(connector.getSource(), connector.getTarget()); 
								
							}
							
						}
					});

					
			}
			
			
		});
		
		
		getConnectableElement().addDiagramElementListener(new DiagramElementListenerAdapter(){
			
			@Override
			public void onRefreshSVGPosition() {
			
				if (connectableElementIsLoaded){

					refreshMagnetsPosition();
					
					refreshConnectedConnectors();
					
				}

			
			}
			
			
			@Override
			public void onRefreshSVGSize() {
				
				if (connectableElementIsLoaded){
					refreshMagnetsPosition();
					refreshConnectedConnectors();
				}
			
			}
			
			
			@Override
			public void onLoad() {
				

				connectableElementIsLoaded = true;
				
				attachMagnetsToConnectableElement();
				
				
			}
			
			
			public void onRemove(){
				
				remove();
				
			}



		});
		
		
	}
	
	private void attachMagnetsToConnectableElement() {
		

		//TOP LEFT
		tLMagnet = new Magnet(Connectable.this);
		
		if (magnetDisposition == MagnetDisposition.All || magnetDisposition == MagnetDisposition.Extremities){
			getConnectableElement().getDiagramPanel().add(tLMagnet);
			actualMagnets.add(tLMagnet);
		}
	
		
		
		//TOP MIDDLE
		tMMagnet = new Magnet(Connectable.this);
		
		if (magnetDisposition == MagnetDisposition.All || magnetDisposition == MagnetDisposition.Middles){
			getConnectableElement().getDiagramPanel().add(tMMagnet);
			actualMagnets.add(tMMagnet);
		}
		
		
		
		
	    //top right
		tRMagnet = new Magnet(Connectable.this);
		
		if (magnetDisposition == MagnetDisposition.All || magnetDisposition == MagnetDisposition.Extremities){
			getConnectableElement().getDiagramPanel().add(tRMagnet);
			actualMagnets.add(tRMagnet);
		}
		
		


		
	    //left middle
		lMMagnet = new Magnet(Connectable.this);
		
		if (magnetDisposition == MagnetDisposition.All || magnetDisposition == MagnetDisposition.Middles){
			getConnectableElement().getDiagramPanel().add(lMMagnet);
			actualMagnets.add(lMMagnet);
		}


		
	    //bottom left
		bLMagnet = new Magnet(Connectable.this);

		if (magnetDisposition == MagnetDisposition.All || magnetDisposition == MagnetDisposition.Extremities){
			getConnectableElement().getDiagramPanel().add(bLMagnet);
			actualMagnets.add(bLMagnet);
		}
		



		
	    //bottom middle
		bMMagnet = new Magnet(Connectable.this);
		
		if (magnetDisposition == MagnetDisposition.All || magnetDisposition == MagnetDisposition.Middles){
			getConnectableElement().getDiagramPanel().add(bMMagnet);
			actualMagnets.add(bMMagnet);
		}
		



		
		//bottom right
		bRMagnet = new Magnet(Connectable.this);

		if (magnetDisposition == MagnetDisposition.All || magnetDisposition == MagnetDisposition.Extremities){
			getConnectableElement().getDiagramPanel().add(bRMagnet);
			actualMagnets.add(bRMagnet);
		}
		


		
		
		//right middle
		rMMagnet = new Magnet(Connectable.this);
		
		if (magnetDisposition == MagnetDisposition.All || magnetDisposition == MagnetDisposition.Middles){
			getConnectableElement().getDiagramPanel().add(rMMagnet);
			actualMagnets.add(rMMagnet);
		}

		refreshMagnetsPosition();
		
	}
	
	
	public void refreshConnectedConnectors(){
		
		
		for(DiagramConnector connector:getIncommingConnectors()){
			
			if (connector.getBeginPoint().isLoaded()){		
				connector.getBeginPoint().setX(connector.getBeginPoint().getAttachedToMagnet().getX());
				connector.getBeginPoint().setY(connector.getBeginPoint().getAttachedToMagnet().getY());
				connector.refresh();				
			}

		}
		
		for(DiagramConnector connector:getOutgoingConnectors()){
			
			if (connector.getEndPoint().isLoaded()){
				connector.getEndPoint().setX(connector.getEndPoint().getAttachedToMagnet().getX());
				connector.getEndPoint().setY(connector.getEndPoint().getAttachedToMagnet().getY());
				connector.refresh();				
			}
		
		
		}
		
	}
	
	public void refreshMagnetsPosition(){
		
		MagnetPositionHelper mph = new MagnetPositionHelper(Connectable.this);
		
		if (magnetDisposition == MagnetDisposition.All || magnetDisposition == MagnetDisposition.Extremities){
		tLMagnet.setX(mph.getMagetTopLeftPosition().getX());
		tLMagnet.setY(mph.getMagetTopLeftPosition().getY());
		}
		
		if (magnetDisposition == MagnetDisposition.All || magnetDisposition == MagnetDisposition.Middles){
			tMMagnet.setX(mph.getMagetTopMiddlePosition().getX());
			tMMagnet.setY(mph.getMagetTopMiddlePosition().getY());			
		}

		if (magnetDisposition == MagnetDisposition.All || magnetDisposition == MagnetDisposition.Extremities){
		tRMagnet.setX(mph.getMagetTopRightPosition().getX());
		tRMagnet.setY(mph.getMagetTopRightPosition().getY());
		}
		
		if (magnetDisposition == MagnetDisposition.All || magnetDisposition == MagnetDisposition.Middles){
		lMMagnet.setX(mph.getMagetLeftMiddlePosition().getX());
		lMMagnet.setY(mph.getMagetLeftMiddlePosition().getY());
		}
		
		if (magnetDisposition == MagnetDisposition.All || magnetDisposition == MagnetDisposition.Extremities){
		bLMagnet.setX(mph.getMagetBottomLeftPosition().getX());
		bLMagnet.setY(mph.getMagetBottomLeftPosition().getY());
		}
		
		if (magnetDisposition == MagnetDisposition.All || magnetDisposition == MagnetDisposition.Middles){
		bMMagnet.setX(mph.getMagetBottomMiddlePosition().getX());
		bMMagnet.setY(mph.getMagetBottomMiddlePosition().getY());
		}
		
		if (magnetDisposition == MagnetDisposition.All || magnetDisposition == MagnetDisposition.Extremities){
		bRMagnet.setX(mph.getMagetBottomRightPosition().getX());
		bRMagnet.setY(mph.getMagetBottomRightPosition().getY());
		}
		
		if (magnetDisposition == MagnetDisposition.All || magnetDisposition == MagnetDisposition.Middles){
		rMMagnet.setX(mph.getMagetRightMidlePosition().getX());
		rMMagnet.setY(mph.getMagetRightMidlePosition().getY());
		}
	
	
	}
	
	
	
	public MagnetDisposition getMagnetDisposition() {
		return magnetDisposition;
	}
	
	public DiagramElement getConnectableElement() {
		return connectableElement;
	}
	
	public void addConnectorExtrimity(ConnectorExtremity extremity){
		if (connectorExtremities.contains(extremity)==false) this.connectorExtremities.add(extremity);
	}
	
	public void removeConnectorExtremity(ConnectorExtremity extremity){
		this.connectorExtremities.remove(extremity);
	}
	
	public ArrayList<DiagramConnector> getIncommingConnectors(){
		
		ArrayList<DiagramConnector> result = new ArrayList<DiagramConnector>();
		
		for(ConnectorExtremity extremity:connectorExtremities){
			
			if (extremity instanceof ConnectorBeginPoint){
				
				result.add(extremity.getConnector());
				
			}
			
		}
		
		return result;
	}
	
	public ArrayList<DiagramConnector> getOutgoingConnectors(){
		
		ArrayList<DiagramConnector> result = new ArrayList<DiagramConnector>();
		
		for(ConnectorExtremity extremity:connectorExtremities){
			
			if (extremity instanceof ConnectorEndPoint){
				
				result.add(extremity.getConnector());
				
			}
			
		}
		
		return result;
	}	
	
	
	public void remove(){
		
		//remove all magnets
		for(Magnet m:this.actualMagnets){
			m.remove();
		}
		
		//remove all incoming and outgoing connectors
		for(DiagramConnector c: this.getIncommingConnectors()){
			c.remove();
		}

		for(DiagramConnector c: this.getOutgoingConnectors()){
			c.remove();
		}
		
	}
	
	
	public ArrayList<Magnet> getActualMagnets() {
		return actualMagnets;
	}

	public void onHide(HideEvent event) {
		// request hide on my element :
		// hide all my connector extremities - and their related lines
		for (ConnectorExtremity connection : connectorExtremities) {
			connection.hide();
		}
		
	}

	public void onShow(ShowEvent event) {
		for (ConnectorExtremity connection : connectorExtremities){
			connection.show();
		}
	}
	
}
