/**
 * Raphael Diagram - A crossbrowser SVG/VML library creating diagrams - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.gwt.raphael.client.diagram.connector;

import com.ebmwebsourcing.gwt.jquery.client.core.J4GUI.SnapMode;
import com.ebmwebsourcing.gwt.raphael.client.core.SVGElement;
import com.ebmwebsourcing.gwt.raphael.client.diagram.element.DiagramElement;
import com.ebmwebsourcing.gwt.raphael.client.diagram.event.DiagramElementDragListenerAdapter;
import com.ebmwebsourcing.gwt.raphael.client.diagram.semantic.DiagramEntity;




public class ConnectorExtremity extends DiagramElement implements DiagramEntity{
	
	private DiagramConnector connector;
	
	private Magnet attachedToMagnet;
	private boolean hidden;
	
	public ConnectorExtremity(SVGElement svgElement,DiagramConnector connector) {
		super(svgElement,new ConnectorExtremityType());
		
		
		this.connector = connector;
		
		hidden = false;
	}
	
	
	public DiagramConnector getConnector() {
		return connector;
	}
	
	
	@Override
	protected void onLoad() {
		super.onLoad();

		this.getJqueryObject().draggableSnap(".magnet");
		this.getJqueryObject().draggableSnapMode(SnapMode.Inner);
		this.getJqueryObject().draggableSnapTolerance(5);
		

	}
	
	
	@Override
	protected void attachDefaultListeners() {
		super.attachDefaultListeners();
		
		
		this.addDragListener(new DiagramElementDragListenerAdapter() {

			@Override
			public void onDrag(DiagramElement diagramElement) {

				refreshSVGPosition();

			}
		});
		
	}
	
	
	public Magnet getAttachedToMagnet() {
		return attachedToMagnet;
	}
	
	public void setAttachedToMagnet(Magnet attachedToMagnet) {
		this.attachedToMagnet = attachedToMagnet;
	}


	@Override
	protected void hideSpecific() {
		if (!hidden){
			super.hideSpecific();
			hidden =true;
			connector.hide();
		}
	}
	
	@Override
	protected void showSpecific(){
		if (hidden){
			super.showSpecific();
			hidden = false;
			connector.show();
		}
	}
	
	
}
