/**
 * Raphael Diagram - A crossbrowser SVG/VML library creating diagrams - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.gwt.raphael.client.diagram.connector;


import com.ebmwebsourcing.gwt.raphael.client.core.Rectangle;
import com.ebmwebsourcing.gwt.raphael.client.diagram.element.DiagramElement;
import com.ebmwebsourcing.gwt.raphael.client.diagram.event.DiagramConnectorListener;
import com.ebmwebsourcing.gwt.raphael.client.diagram.event.DiagramElementDropListenerAdapter;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONString;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Timer;


public class Magnet extends DiagramElement {
	
	private Connectable connectable;
	
	
	private static int MAGNET_WIDTH 		= 10;
	private static int MAGNET_HEIGHT 		= 10;
	
	public Magnet(final Connectable connectable) {
		
		super(new Rectangle(DOM.createUniqueId(), 0, 0,MAGNET_WIDTH,MAGNET_HEIGHT, 3));
		
		this.connectable = connectable; 
		
		this.isDroppable(true);
		
		this.addStyleName("magnet");
	
		this.addDropListener(new DiagramElementDropListenerAdapter(){
			
			@Override
			public void onOver(DiagramElement diagramElement,DiagramElement overElement) {
			
					if (overElement instanceof ConnectorExtremity){
							
							Magnet.this.show();
						
					}
				
				
			}
			
			
			
			
			
			
			@Override
			public void onDrop(DiagramElement targetElement, DiagramElement droppedElement) {
				
				
				if (droppedElement instanceof ConnectorExtremity){
					
					ConnectorExtremity extremity = (ConnectorExtremity) droppedElement;
					
					//tell the connector we just dropped one of its extremities on a connectable
					for(DiagramConnectorListener l:extremity.getConnector().getListeners()){
						l.onExtremityConnected(extremity, connectable);
					}
				
					
					
					addExtremity(extremity);
					
					Magnet.this.hide();

					
						if (extremity instanceof ConnectorBeginPoint){
						
							extremity.getConnector().setTarget(connectable);

							extremity.setAttachedToMagnet(Magnet.this);

							
						}else if (extremity instanceof ConnectorEndPoint){
							
							extremity.getConnector().setSource(connectable);

							extremity.setAttachedToMagnet(Magnet.this);
							
						}
						
					//if current connectable has a target and source trigger means that connector is fully connected	
					if (extremity.getConnector().getSource()!=null && extremity.getConnector().getTarget()!=null){
						
						for(DiagramConnectorListener l:extremity.getConnector().getListeners()){
							l.onConnected(extremity.getConnector().getSource(), extremity.getConnector().getTarget());
						}
						
					}
					
				}
				
				
			}
			
			@Override
			public void onOut(DiagramElement targetElement,
					DiagramElement outElement) {
				
				if (outElement instanceof ConnectorExtremity){
					
					ConnectorExtremity extremity = (ConnectorExtremity) outElement;
					
					
					//tell the connector we just removed one of its extremities on a connectable
					for(DiagramConnectorListener l:extremity.getConnector().getListeners()){
						l.onExtremityDisconnected(extremity, connectable);
					}
					
					
					removeExtremity(extremity);
					
					Magnet.this.hide();

					
					if (extremity instanceof ConnectorBeginPoint){
						
						extremity.getConnector().setTarget(null);
						extremity.setAttachedToMagnet(null);

						
					}else if (extremity instanceof ConnectorEndPoint){
						
						extremity.getConnector().setSource(null);
						extremity.setAttachedToMagnet(null);

						
					}
					
					
					//if current connectable has no target and no source trigger means that connector is fully disconnected	
					if (extremity.getConnector().getSource()==null && extremity.getConnector().getTarget()==null){
						
						for(DiagramConnectorListener l:extremity.getConnector().getListeners()){
							l.onDisconnected();
						}
						
					}
					
					
					
				
				}
				
			}
			
			
		});

		
	}
	
	@Override
	protected void showSpecific(){
		
		Magnet.this.getSvgElement().show();
	
		JSONObject json = new JSONObject();
	     
	     json.put("fill", new JSONString("red"));
	     json.put("opacity", new JSONString("0.5"));
	     
	     Magnet.this.getSvgElement().animate(json.getJavaScriptObject(), 500);

	}
	
	@Override
	protected void hideSpecific(){

		JSONObject json = new JSONObject();
	     
	    json.put("fill", new JSONString("white"));
	     
	    this.getSvgElement().animate(json.getJavaScriptObject(), 500);
	    
	    Timer timer = new Timer(){

			@Override
			public void run() {
				
				Magnet.this.getSvgElement().hide();
				
			}
	    	
	    };
	    
	    timer.schedule(450);
		
	}
	
	public void addExtremity(ConnectorExtremity extremity){
		
		this.connectable.addConnectorExtrimity(extremity);
		
	}
	
	private void removeExtremity(ConnectorExtremity extremity){
		this.connectable.removeConnectorExtremity(extremity);
	}
	

	public Connectable getConnectable() {
		return connectable;
	}
	
	public static int getMAGNET_HEIGHT() {
		return MAGNET_HEIGHT;
	}
	public static int getMAGNET_WIDTH() {
		return MAGNET_WIDTH;
	}
	
	@Override
	protected void onLoad() {
		super.onLoad();
		
		getSvgElement().attr("stroke", "transparent");
		getSvgElement().attr("fill", "white");
		getSvgElement().hide();
	}
	
	
}
