/**
 * Raphael Diagram - A crossbrowser SVG/VML library creating diagrams - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.gwt.raphael.client.diagram.event;

import com.ebmwebsourcing.gwt.raphael.client.diagram.element.DiagramComplexElement;
import com.google.gwt.event.shared.GwtEvent;

/**
 * These events are fired by DiagramComplexElements
 * GWT 2.0 event handling style.
 * @author enhan
 *
 */
public class ComplexElementEvent extends GwtEvent<ComplexElementHandler> {

	private static Type<ComplexElementHandler> TYPE;
	
	
	
	public static Type<ComplexElementHandler> getType(){
		 if (TYPE == null) {
		      TYPE = new Type<ComplexElementHandler>();
		    }
		    return TYPE;
	}
	
	public static void fire(DiagramComplexElement source){
		if (TYPE != null){
			ComplexElementEvent ev = new ComplexElementEvent();
			source.fireEvent(ev);
		}
	}
	
	
	
	protected ComplexElementEvent(){
		
	}

	@Override
	protected void dispatch(ComplexElementHandler arg0) {
		arg0.onSvgRefresh(this);
	}

	@Override
	public Type<ComplexElementHandler> getAssociatedType() {
		return TYPE;
	}
	
	


}
