/**
 * Raphael Diagram - A crossbrowser SVG/VML library creating diagrams - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.gwt.raphael.client.diagram.event;

import com.ebmwebsourcing.gwt.jquery.client.ui.handler.adapter.SelectableHandlerAdapter;
import com.ebmwebsourcing.gwt.raphael.client.diagram.DiagramPanel;
import com.google.gwt.user.client.Event;
import com.j4g.client.api.F;

/**
 * 
 * @author nfleury
 *
 */
public class DiagramPanelListenerBinder {
	
	private DiagramPanel diagramPanel;
	
	public DiagramPanelListenerBinder(final DiagramPanel diagramPanel) {
		
		this.diagramPanel = diagramPanel;
		
		
		//Bind click event
		diagramPanel.getJqueryObject().bind("click", new F(){
			
			public void f(Event event) {
				
				for(DiagramPanelListener listener:diagramPanel.getPanelListeners()){
					
					listener.onClick();
					
				}
					
			}
			
		});
		
		//Bind selectable handler to diagram listener
		SelectableHandlerAdapter sha = new SelectableHandlerAdapter(){
			
			@Override
			public F selected() {
				
				F f = new F(){
					public void f(Event event) {
						
						for(DiagramPanelListener listener:diagramPanel.getPanelListeners()){
							
							listener.onSelected();
							
						}
						
					}
				};
				
				return f;
			}
			
			@Override
			public F selecting() {
				F f = new F(){
					public void f(Event event) {
						
						for(DiagramPanelListener listener:diagramPanel.getPanelListeners()){
							
							listener.onSelecting();
							
						}
						
					}
				};
				
				return f;			
				
			
			}
			
			@Override
			public F start() {
				F f = new F(){
					public void f(Event event) {
						
						for(DiagramPanelListener listener:diagramPanel.getPanelListeners()){
							
							listener.onSelectStart();
							
						}
						
					}
				};
				
				return f;
			}
			
			@Override
			public F stop() {
				F f = new F(){
					public void f(Event event) {
						
						
						diagramPanel.defaultSelectableStopFunction();
						
						for(DiagramPanelListener listener:diagramPanel.getPanelListeners()){
							
							listener.onSelectStop();
							
						}
						
					}
				};
				
				return f;			
				
			}
			
			@Override
			public F unselected() {
				F f = new F(){
					public void f(Event event) {
						
						for(DiagramPanelListener listener:diagramPanel.getPanelListeners()){
							
							listener.onUnselected();
							
						}
						
					}
				};
				
				return f;			
			}
			
			@Override
			public F unselecting() {
				F f = new F(){
					public void f(Event event) {
						
						for(DiagramPanelListener listener:diagramPanel.getPanelListeners()){
							
							listener.onUnselecting();
							
						}
						
					}
				};
				
				return f;	
				
			}
			
		};
		

		diagramPanel.getJqueryObject().selectable(sha);
		
	}
	
}
