/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


package com.ebmwebsourcing.geasybpmneditor.bpmndiagram.builders;

import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.common.IFlowElementBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.common.IFlowNodeBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.process.IProcessBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.mock.IdGenerator;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.DefinitionsHelper;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.collaboration.CollaborationBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.collaboration.LaneBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.collaboration.LaneSetBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.common.MessageFlowBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.common.ParticipantBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.common.PartnerRoleBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.infrastructure.DefinitionsBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.ProcessBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.activity.TaskBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.event.EndEventBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.event.StartEventBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.gateway.GatewayBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.gateway.SequenceFlowBean;
import com.ebmwebsourcing.bpmneditor.business.domain.di.impl.BPMNEdge;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.collaboration.Lane;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.collaboration.Pool;
import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramElementView;
import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramView;
import com.ebmwebsourcing.geasytools.diagrameditor.api.syntax.IDiagramSyntaxModelBuilder;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IModelElement;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IUIElement;

public class BPMNCollaborationSyntaxModelBuilder implements IDiagramSyntaxModelBuilder {

    private IDiagramView diagramView;
    private DefinitionsBean def;
    private CollaborationBean collaboration;

    public BPMNCollaborationSyntaxModelBuilder(IDiagramView diagramView) {
        this.diagramView = diagramView;
    }

    public IModelElement getSyntaxModel() {
        def = (DefinitionsBean) diagramView.getMainModel();
        
        if(def.getCollaborations().isEmpty()) {
            createDefinition(diagramView);
        }

        for (IUIElement el : diagramView.getUIElements().values()) {

            IDiagramElementView elview = (IDiagramElementView) el;
            
            if (elview instanceof Pool) {
                Pool pool = (Pool) elview;
                ParticipantBean participant = (ParticipantBean) pool.getDiagramElement().getModelElement();
                collaboration.addParticipant(participant);
                
                PartnerRoleBean role = new PartnerRoleBean(IdGenerator.createUniqueId());
                role.setName(participant.getName()+"_role");
                role.addParticipant(participant);
                def.addPartnerRole(role);
                
                ProcessBean process = new ProcessBean();
                process.setName(participant.getName()+"_process");
                participant.setProcess(process);
                def.addProcess(process);
                LaneSetBean laneset = new LaneSetBean(IdGenerator.createUniqueId());
                process.addLaneSet(laneset);
                
                for(IUIElement laneEl : pool.getLanes().values()) {
                    Lane lane = (Lane) laneEl;
                    LaneBean laneBean = (LaneBean) lane.getDiagramElement().getModelElement();
                    laneset.addLane(laneBean);
                    
                    for(IUIElement flowEltEl : lane.getFlowElements().values()) {
                        IDiagramElementView flowEltelview = (IDiagramElementView) flowEltEl;
                        
                        if ((flowEltelview.getDiagramElement().getModelElement() instanceof TaskBean)) {
                            TaskBean tb = (TaskBean) flowEltelview.getDiagramElement().getModelElement();
                            laneBean.addTask(tb);
                            process.addTask(tb);
                        } else if ((flowEltelview.getDiagramElement().getModelElement() instanceof EndEventBean)) {
                            EndEventBean eeb = (EndEventBean) flowEltelview.getDiagramElement().getModelElement();
                            laneBean.addEndEvent(eeb);
                            process.addEndEvent(eeb);
                        } else if (flowEltelview.getDiagramElement().getModelElement() instanceof StartEventBean) {
                            StartEventBean seb = (StartEventBean) flowEltelview.getDiagramElement().getModelElement();
                            laneBean.addStartEvent(seb);
                            process.addStartEvent(seb);
                        } else if (flowEltelview.getDiagramElement().getModelElement() instanceof GatewayBean) {
                            GatewayBean gb = (GatewayBean) flowEltelview.getDiagramElement().getModelElement();
                            laneBean.addGateway(gb);
                            process.addGateway(gb);
                        }
                    }
                    
                }
            }

        }

        for (IUIElement el : diagramView.getUIElements().values()) {
            IDiagramElementView elview = (IDiagramElementView) el;

            if (elview.getDiagramElement().getModelElement() instanceof SequenceFlowBean) {
                BPMNEdge edge = (BPMNEdge) elview.getDiagramElement();
                SequenceFlowBean sf = (SequenceFlowBean) edge.getModelElement();

                IProcessBean parentProcess = null;
                if (edge.getSource() != null) {
                    sf.setSourceNode((IFlowElementBean) DefinitionsHelper.getInstance().getElementById(def, edge.getSource().getId()));
                    parentProcess = DefinitionsHelper.getInstance().getParentProcess(sf.getSourceNode(), def);
                }
                if (edge.getTarget() != null) {
                    sf.setTargetNode((IFlowElementBean) DefinitionsHelper.getInstance().getElementById(def, edge.getTarget().getId()));
                    if(parentProcess==null) {
                        parentProcess = DefinitionsHelper.getInstance().getParentProcess(sf.getTargetNode(), def);
                    }
                }

                parentProcess.addSequenceFlow(sf);
            }
            
            if (elview.getDiagramElement().getModelElement() instanceof MessageFlowBean) {
                BPMNEdge edge = (BPMNEdge) elview.getDiagramElement();
                MessageFlowBean mf = (MessageFlowBean) edge.getModelElement();

                if (edge.getSource() != null) {
                    mf.setSource((IFlowNodeBean) DefinitionsHelper.getInstance().getElementById(def, edge.getSource().getId()));
                }
                if (edge.getTarget() != null) {
                    mf.setTarget((IFlowNodeBean) DefinitionsHelper.getInstance().getElementById(def, edge.getTarget().getId()));
                }

                collaboration.addMessageFlow(mf);
            }
        }

        return collaboration;
    }

    private DefinitionsBean createDefinition(IDiagramView di) {
        // Definition attributes
        def.setTargetNamespace("http://com.ebmwebsourcing.easybpmn/");
        def.setTypeLanguage("http://www.w3.org/2001/XMLSchema");
        def.setExpressionLanguage("http://www.w3.org/1999/XPath");

        // Add collaboration to definition
        collaboration = new CollaborationBean(IdGenerator.createUniqueId());
        collaboration.setName("main collaboration");

        def.addCollaboration(collaboration);

        return def;
    }

    public IDiagramView getDiagramView() {
        return diagramView;
    }

}
