/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasybpmneditor.bpmndiagram.builders;


import java.util.Collection;

import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.Constants.ProcessTypes;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.mock.IdGenerator;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.DefinitionsHelper;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.collaboration.CollaborationBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.collaboration.LaneBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.collaboration.LaneSetBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.common.ParticipantBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.common.PartnerRoleBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.infrastructure.DefinitionsBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.ProcessBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.activity.TaskBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.event.EndEventBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.event.StartEventBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.gateway.GatewayBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.gateway.SequenceFlowBean;
import com.ebmwebsourcing.bpmneditor.business.domain.di.impl.BPMNEdge;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.collaboration.Lane;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.collaboration.Pool;
import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramElementView;
import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramView;
import com.ebmwebsourcing.geasytools.diagrameditor.api.syntax.IDiagramSyntaxModelBuilder;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IModelElement;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IUIElement;

/**
 * TODO: Should directly add process into definition but current implementation
 * doesn't allow it ... so for now we say that we always have a collaboration even
 * if we have a single process 
 * 
 * 
 * @author nfleury
 *
 */
public class BPMNPrivateProcessSyntaxModelBuilder implements IDiagramSyntaxModelBuilder{

    private DefinitionsBean defs;
    private ParticipantBean participant;
    private PartnerRoleBean role;
    private LaneSetBean laneSet;
	private ProcessBean process;
	private IDiagramView diagramView;
	private CollaborationBean collaboration;
	
	
	public BPMNPrivateProcessSyntaxModelBuilder(IDiagramView diagramView) {
		this.diagramView = diagramView;
	}

	@Override
	public IModelElement getSyntaxModel() {
	    defs = (DefinitionsBean) diagramView.getMainModel();
	    

		
        createProcess(diagramView);
        createLaneSet();
		
		for(IUIElement el : diagramView.getUIElements().values()) {
		    IDiagramElementView elview = (IDiagramElementView) el;

		    if(elview instanceof Pool) {
		        Pool pool = (Pool) elview;
		        
		        if (defs.getCollaborations().size()>1) defs.getCollaborations().get(0).removeParticipant(participant);
		        
		        participant = (ParticipantBean) pool.getDiagramElement().getModelElement();
		        defs.getCollaborations().get(0).addParticipant(participant);

		        defs.removePartnerRole(role);
		        role = new PartnerRoleBean(IdGenerator.createUniqueId());
		        role.setName(participant.getName()+"_role");
		        role.addParticipant(participant);
		        defs.addPartnerRole(role);
		        

		        createLaneSet();

		        for(IUIElement laneEl : pool.getLanes().values()) {
		            Lane lane = (Lane) laneEl;
		            LaneBean laneBean = (LaneBean) lane.getDiagramElement().getModelElement();
		            laneSet.addLane(laneBean);

		            fillLane(laneBean, lane.getFlowElements().values());
		        }
		    }
		}
		
		if(laneSet.getLanes()==null || laneSet.getLanes().isEmpty()) {
		    LaneBean lane = new LaneBean(IdGenerator.createUniqueId());
	        lane.setName("Internal role");
	        laneSet.addLane(lane);
	        
	        fillLane(lane,diagramView.getUIElements().values());
		}
		
		for(IUIElement el:diagramView.getUIElements().values()){
			IDiagramElementView elview = (IDiagramElementView) el;
			
			if (elview.getDiagramElement().getModelElement() instanceof SequenceFlowBean){
				BPMNEdge edge = (BPMNEdge) elview.getDiagramElement();
				SequenceFlowBean sf = (SequenceFlowBean) edge.getModelElement();
				
				if(edge.getSource()!=null){
					sf.setSourceNode(DefinitionsHelper.getInstance().getFlowNodeById(edge.getSource().getId(), process));
				}
				if(edge.getTarget()!=null){
					sf.setTargetNode(DefinitionsHelper.getInstance().getFlowNodeById(edge.getTarget().getId(), process));
				}
				
				process.addSequenceFlow(sf);
			}
		}
		
		return process;
	}
	
	
	private void fillLane(LaneBean lane, Collection<IUIElement> elts) {
	    for(IUIElement el : elts){
            IDiagramElementView elview = (IDiagramElementView) el;
            
            if (elview.getDiagramElement().getModelElement() instanceof TaskBean) {
                
                TaskBean tb = (TaskBean) elview.getDiagramElement().getModelElement();
                lane.addTask(tb);
                process.addTask(tb);
                
            }else if ((elview.getDiagramElement().getModelElement() instanceof EndEventBean)){
                
                EndEventBean eeb = (EndEventBean) elview.getDiagramElement().getModelElement();
                lane.addEndEvent(eeb);
                process.addEndEvent(eeb);
                
            }else if (elview.getDiagramElement().getModelElement() instanceof StartEventBean){
                
                StartEventBean seb = (StartEventBean) elview.getDiagramElement().getModelElement(); 
                lane.addStartEvent(seb);
                process.addStartEvent(seb);
                
            }else if (elview.getDiagramElement().getModelElement() instanceof GatewayBean){
                
                GatewayBean gb = (GatewayBean) elview.getDiagramElement().getModelElement();
                lane.addGateway(gb);
                process.addGateway(gb);
            
            }
        }
	}
	

	
	
	


	
	private void createProcess(IDiagramView di) {
	    if(process!=null) {
	        defs.removeProcess(process);
	    }
	    
	    if (collaboration==null){
	    	collaboration= new CollaborationBean(IdGenerator.createUniqueId());
	    	defs.addCollaboration(collaboration);
	    }
	    
	    
	    this.process = new ProcessBean(di.getId());
        process.setName(di.getId());
        process.setType(ProcessTypes.PUBLIC);
        

        defs.addProcess(process);
	}
	
	private void createLaneSet() {
	    laneSet = new LaneSetBean(IdGenerator.createUniqueId());
	    process.addLaneSet(laneSet);
	}


	@Override
	public IDiagramView getDiagramView() {
		return diagramView;
	}
	

}
