/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasybpmneditor.bpmndiagram.common;

import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.DescriptiveProcessPanel;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.collaboration.SwimlaneFactory;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.data.DataFactory;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.events.EventFactory;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.gateways.GatewayFactory;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.process.activities.ActivityFactory;
import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramElementGraphicFactory;
import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramElementView;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IDiagramElement;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IUIElement;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.IHasDragProxy;

public class BPMNElementFactory implements IDiagramElementGraphicFactory{

	private ActivityFactory activityFactory;
	private SwimlaneFactory swimlaneFactory;
	private CommonFactory commonFactory;
	private EventFactory eventFactory;
	private GatewayFactory gatewayFactory;
	private DataFactory dataFactorty;
	
	private DescriptiveProcessPanel definitionPanel;
	
	public BPMNElementFactory(DescriptiveProcessPanel definitionPanel) {
		
		this.definitionPanel = definitionPanel;
		
		this.activityFactory = new ActivityFactory(definitionPanel);
		this.swimlaneFactory = new SwimlaneFactory(definitionPanel);
		this.commonFactory 	 = new CommonFactory(definitionPanel);
		this.eventFactory 	 = new EventFactory(definitionPanel);
		this.gatewayFactory	 = new GatewayFactory(definitionPanel);
		this.dataFactorty	 = new DataFactory(definitionPanel);
	}
	
	public ActivityFactory getActivityFactory() {
		return activityFactory;
	}
	
	public DescriptiveProcessPanel getDefinitionPanel() {
		return definitionPanel;
	}
	

	public IUIElement getElement(IHasDragProxy draggableProxyData) {
		
		IBPMNElement activity = activityFactory.getActivity(draggableProxyData);
		
		if (activity==null){
			
			activity = swimlaneFactory.getSwimlane(draggableProxyData);
			
		}
		if (activity==null){
			
			activity = commonFactory.getCommonElement(draggableProxyData);
			
		}
		
		if (activity==null){
			
			activity = eventFactory.getEvent(draggableProxyData);
			
		}		
		
		if (activity ==null){
			
			activity = gatewayFactory.getGateway(draggableProxyData);
		}
		
		if (activity ==null){
			
			activity = dataFactorty.getData(draggableProxyData);
			
		}
		
		if (activity !=null){
			return activity;
		}
		
		return null; 
	}

	public IUIElement getElement(Class<? extends IUIElement> elementType) {
		
		IUIElement el = commonFactory.getElement(elementType);
		
		
		
		return el;
	}

	public IDiagramElementView getElement(
			Class<? extends IDiagramElementView> elementType) {
		
		
	
		
		
		return null;
	}


	public IDiagramElementView getElementByDiagramElementModel(
			IDiagramElement diagramElement) {
	
		
		IDiagramElementView el = commonFactory.getElementByDiagramElementModel(diagramElement);
		
		if (el==null){
			
			el = swimlaneFactory.getElementByDiagramElementModel(diagramElement);
			
		}
		
		if (el==null){
			
			el = activityFactory.getElementByDiagramElementModel(diagramElement);
			
		}
		
		if (el==null){
			
			el = gatewayFactory.getElementByDiagramElementModel(diagramElement);
			
		}
		
		if (el==null){
			
			el = eventFactory.getElementByDiagramElementModel(diagramElement);
			
		}
		
		
		return el;
	}
	
}
