/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasybpmneditor.bpmndiagram.common;

import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.common.MessageFlowBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.data.DataAssociationBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.data.DataInputAssociationBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.gateway.SequenceFlowBean;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.DescriptiveProcessPanel;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.connectors.DataAssociation;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.connectors.MessageFlow;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.connectors.SequenceFlow;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.editormodels.MessageFlowEditorModel;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.editormodels.SequenceFlowEditorModel;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.modeleditor.template.DataAssociationFormTemplate;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.modeleditor.template.MessageFlowFormTemplate;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.modeleditor.template.SequenceFlowFormTemplate;
import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramElementGraphicFactory;
import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramElementView;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IDiagramElement;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IUIElement;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.IHasDragProxy;
import com.google.gwt.user.client.DOM;

public class CommonFactory implements IDiagramElementGraphicFactory{

	private DescriptiveProcessPanel definitionPanel;
	
	public CommonFactory(DescriptiveProcessPanel definitionPanel) {
		this.definitionPanel = definitionPanel;
	}
	
	public IBPMNElement getCommonElement(IHasDragProxy bpmndragproxydata){
	
		
		if (bpmndragproxydata.getIUIElementType()==SequenceFlow.class){
				return this.createSequenceFlow(null);
		
		}else if (bpmndragproxydata.getIUIElementType()==MessageFlow.class){
			
				return this.createMessageFlow(null);
			
		}else if (bpmndragproxydata.getIUIElementType()==DataAssociation.class){
			
			return this.createDataAssociation(null);
		}
		
		
		
		
		return null;
	}


	
	
	private SequenceFlow createSequenceFlow(SequenceFlowBean sequenceFlowBean){
		
		String id = DOM.createUniqueId();
		
		if (sequenceFlowBean!=null) sequenceFlowBean.getId();
		
		SequenceFlow sequenceFlowView = new SequenceFlow(definitionPanel, id);
		
		if (sequenceFlowBean==null){
		
			sequenceFlowView.getDiagramElement().setModelElement(new SequenceFlowBean(id));
			
		}else{
			
			SequenceFlowEditorModel model = (SequenceFlowEditorModel) sequenceFlowView.getEditorModel();
			
			model.setName(sequenceFlowBean.getName());
			model.setDocumentation(sequenceFlowBean.getDocumentation());
			if (sequenceFlowBean.getExpression()!=null) model.setConditionnalExpression(sequenceFlowBean.getExpression().getContent());
			
			sequenceFlowView.getDiagramElement().setModelElement(sequenceFlowBean);			
		}
		

		SequenceFlowFormTemplate sft = new SequenceFlowFormTemplate(sequenceFlowView);
		
		return sequenceFlowView;
	}
	
	private MessageFlow createMessageFlow(MessageFlowBean messageFlowBean){
		
		String id = DOM.createUniqueId();
		
		if (messageFlowBean!=null) id=messageFlowBean.getId();
		
		MessageFlow messageFlowView = new MessageFlow(definitionPanel, id);
		
		if (messageFlowBean==null){
			
			messageFlowView.getDiagramElement().setModelElement(new MessageFlowBean(id));
			
			
		}else{
			
			MessageFlowEditorModel model = (MessageFlowEditorModel) messageFlowView.getEditorModel();
			
			model.setName(messageFlowBean.getName());
			model.setDocumentation(messageFlowBean.getDocumentation());
			model.setMessage(messageFlowBean.getMessage());
			
			messageFlowView.getDiagramElement().setModelElement(messageFlowBean);
			
		}
		

		
		MessageFlowFormTemplate mft = new MessageFlowFormTemplate(messageFlowView);
		
		return messageFlowView;
	}
	
	private DataAssociation createDataAssociation(DataAssociationBean dataAssociationBean){
		
		String id = DOM.createUniqueId();
		
		if (dataAssociationBean!=null) id=dataAssociationBean.getId();
		
		DataAssociation dataAssociationView = new DataAssociation(definitionPanel, id);
		
		if (dataAssociationBean==null){
			
			dataAssociationView.getDiagramElement().setModelElement(new DataInputAssociationBean(id));			
		
		}else{
			
			//TODO
		}
		

		
		DataAssociationFormTemplate daft = new DataAssociationFormTemplate(dataAssociationView);
		
		return dataAssociationView;
	}
	
	

	
	public IDiagramElementView getElement(
			Class<? extends IDiagramElementView> elementType) {
		// TODO Auto-generated method stub
		return null;
	}

	public IDiagramElementView getElementByDiagramElementModel(
			IDiagramElement diagramElement) {
	
		//Sequence Flow
		if (diagramElement.getModelElement() instanceof SequenceFlowBean){
		
			SequenceFlowBean sequenceFlowBean = (SequenceFlowBean) diagramElement.getModelElement();
			
			return this.createSequenceFlow(sequenceFlowBean);
			
		//Message Flow	
		}else if (diagramElement.getModelElement() instanceof MessageFlowBean){
			
			MessageFlowBean messageFlowBean = (MessageFlowBean) diagramElement.getModelElement();

			return this.createMessageFlow(messageFlowBean);
		
		}//TODO Data Association
		
		
		
		return null;
	}

	public IUIElement getElement(IHasDragProxy draggableProxyData) {
		// TODO Auto-generated method stub
		return null;
	}

	public IUIElement getElement(Class<? extends IUIElement> elementType) {
		
		if (elementType==SequenceFlow.class){
			return this.createSequenceFlow(null);
		}else if (elementType==MessageFlow.class){
			return this.createMessageFlow(null);
		}
		
		
		return null;
	}
	

	
	
}
