/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasybpmneditor.bpmndiagram.common;

import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.connectors.SequenceFlow;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.dragproxy.impl.activities.TaskDragProxy;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.process.activities.Activity;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnectableElement;
import com.ebmwebsourcing.geasytools.geasyui.api.contextualmenu.events.IDragProxyContextualMenuHandler;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IProxyAcceptedAfterDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IProxyAcceptedBeforeDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IProxyDragMoveEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IProxyDragStartEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IProxyDragStopEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IProxyRefusedAfterDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IProxyRefusedBeforeDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.IUIPanel;

public class ContextualMenuHandler implements IDragProxyContextualMenuHandler{

	private IConnectableElement bpmnelement;
	private IUIPanel uipanel;
	
	public ContextualMenuHandler(IConnectableElement connectableElement) {
		this.bpmnelement = connectableElement;
		this.uipanel	 = bpmnelement.getUIPanel();
	}
	
	public IUIPanel getUIPanel() {
		return uipanel;
	}
	
	public void onProxyRefusedBeforeDrop(IProxyRefusedBeforeDropEvent event) {}
	
	public void onProxyRefusedAfterDrop(IProxyRefusedAfterDropEvent event) {}
	
	public void onProxyDragStop(IProxyDragStopEvent event) {}
	
	public void onProxyDragStart(IProxyDragStartEvent event) {}
	
	public void onProxyDragMove(IProxyDragMoveEvent event) {}
	
	public void onProxyAcceptedBeforeDrop(IProxyAcceptedBeforeDropEvent event) {}
	
	public void onProxyAcceptedAfterDrop(IProxyAcceptedAfterDropEvent event) {

		if ( event.getDragProxy().getHasDraggableElementProxy().getCreatedElement() instanceof SequenceFlow ==false &&
			event.getDragProxy().getHasDraggableElementProxy().getCreatedElement() != null){

			SequenceFlow sf = (SequenceFlow) getUIPanel().getElementFactory().getElement(SequenceFlow.class);
			getUIPanel().addUIElement(sf);
			sf.connect(bpmnelement, (IConnectableElement) event.getDragProxy().getHasDraggableElementProxy().getCreatedElement());
			
		}
	
		
	}
	
}
