/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasybpmneditor.bpmndiagram.data;

import java.util.HashSet;
import java.util.LinkedHashSet;

import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.BPMNElementsPath;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.DescriptiveProcessPanel;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.editormodels.DataObjectEditorModel;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.modeleditor.template.DataObjectFormTemplate;
import com.ebmwebsourcing.geasytools.diagrameditor.api.modeleditor.IEditorModel;
import com.ebmwebsourcing.geasytools.diagrameditor.api.syntax.IDiagramElementSyntaxModelBinder;
import com.ebmwebsourcing.geasytools.diagrameditor.api.validation.IDiagramElementViewConformityRule;
import com.ebmwebsourcing.geasytools.geasysvg.core.impl.Path;
import com.ebmwebsourcing.geasytools.geasysvg.core.impl.Rectangle;
import com.ebmwebsourcing.geasytools.geasysvg.core.impl.SVGElement;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnectableElementDefaulHandlers;
import com.ebmwebsourcing.geasytools.geasyui.api.contextualmenu.IHasMenuDragProxy;
import com.ebmwebsourcing.geasytools.geasyui.api.contextualmenu.events.IDragProxyContextualMenuHandler;
import com.ebmwebsourcing.geasytools.geasyui.api.core.Direction;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.IDraggableElement;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IDropAcceptedEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IDropRefusedEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IOutEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IOverEvent;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.AbstractUITemplate;
import com.google.gwt.core.client.GWT;

public class DataObject extends Data {
	
	private Path mainPath;
	
	private Rectangle invisibleRectangle;
	
	private DataObjectEditorModel dataEditorModel;
	
	private DataObjectSyntaxModelBinder syntaxBinder;
	

	
	public DataObject(DescriptiveProcessPanel definitionPanel,
			String id) {
		super(definitionPanel, id);
		

		this.syntaxBinder = new DataObjectSyntaxModelBinder();
	}
	
	
	@Override
	protected void init() {
		super.init();
		
		mainPath = this.getDefinitionPanel().getCanvas().createPath(BPMNElementsPath.DATA_DATAOBJECT, 0, 0);
//		mainPath.setStokeColour("#8B5E3C");
//		mainPath.setFillColour("#8B5E3C");
		//mainPath.translate(-5, -3);
		
		
		this.label  = this.getDefinitionPanel().getCanvas().createText(50, 25,"");
		this.getGroup().appendChild(label);
		
		getGroup().appendChild(mainPath);
	
	}
	
	
	@Override
	public SVGElement getMainShape() {
		
		if (invisibleRectangle==null){
			
			invisibleRectangle = this.getDefinitionPanel().getCanvas().createRectangle(0, 0, 30, 45);
			invisibleRectangle.setFillColour("white");
			invisibleRectangle.setStokeColour("white");

		}
		
		return invisibleRectangle;
	}

	@Override
	public void addContextualMenuHandler(IDragProxyContextualMenuHandler handler) {
		// TODO Auto-generated method stub

	}

	@Override
	public LinkedHashSet<IHasMenuDragProxy> getDragProxies() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Direction getMenuDirection() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String getName() {
		return "Data Object";
	}

	@Override
	public HashSet<Class<? extends IDraggableElement>> getAcceptedTypes() {
		
		HashSet<Class<? extends IDraggableElement>> types = new HashSet<Class<? extends IDraggableElement>>();
		
		return types;
	}


	@Override
	public IConnectableElementDefaulHandlers getDefaultHandlers() {
		// TODO Auto-generated method stub
		return null;
	}


	@Override
	public HashSet<IDiagramElementViewConformityRule> getConformityRules() {
		// TODO Auto-generated method stub
		return null;
	}


	@Override
	public IEditorModel getEditorModel() {
		
		if (dataEditorModel==null){
			this.dataEditorModel  = GWT.create(DataObjectEditorModel.class);
		}
		
		return dataEditorModel;
	}


	@Override
	public IDiagramElementSyntaxModelBinder getSyntaxModelBinder() {
		return syntaxBinder;
	}


	@Override
	public void onDropAccepted(IDropAcceptedEvent event) {
		// TODO Auto-generated method stub
		
	}


	@Override
	public void onDropRefused(IDropRefusedEvent event) {
		// TODO Auto-generated method stub
		
	}


	@Override
	public void onOut(IOutEvent event) {
		// TODO Auto-generated method stub
		
	}


	@Override
	public void onOver(IOverEvent event) {
		// TODO Auto-generated method stub
		
	}



}
