/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasybpmneditor.bpmndiagram.dragproxy.impl.common;

import java.util.HashSet;

import com.ebmwebsourcing.geasytools.geasyui.api.core.IUIElement;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IDragProxyHandler;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IProxyAcceptedAfterDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IProxyAcceptedBeforeDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IProxyDragMoveEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IProxyDragStartEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IProxyDragStopEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IProxyRefusedAfterDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IProxyRefusedBeforeDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.IUIPanel;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.HasDragProxy;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.dom.client.MouseMoveEvent;
import com.google.gwt.event.dom.client.MouseMoveHandler;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;

public abstract class AbstractBPMNDragProxy extends HasDragProxy {
	
	private AbsolutePanel panel;
	private Label label;
	private Image ico;
	

	
	public AbstractBPMNDragProxy(IUIPanel uipanel) {
		super(uipanel);
		
		this.setStyleName("palette-element");
		
		
		this.addDragProxyHandler(new IDragProxyHandler() {
			
			public void onProxyRefusedBeforeDrop(IProxyRefusedBeforeDropEvent event) {
				// TODO Auto-generated method stub
				
			}
			
			public void onProxyRefusedAfterDrop(IProxyRefusedAfterDropEvent event) {
				// TODO Auto-generated method stub
				
			}
			
			public void onProxyDragStop(IProxyDragStopEvent event) {
				// TODO Auto-generated method stub
				
			}
			
			public void onProxyDragStart(IProxyDragStartEvent event) {
//				System.out.println("Drag proxy Start");
//				AbsolutePanel ap = (AbsolutePanel)event.getDragProxy().getHasDraggableElementProxy();
//				
//				ap.add(droppableImage);

			}
			
			public void onProxyDragMove(IProxyDragMoveEvent event) {
				// TODO Auto-generated method stub
				
			}
			
			public void onProxyAcceptedBeforeDrop(IProxyAcceptedBeforeDropEvent event) {
				// TODO Auto-generated method stub
				
			}
			
			public void onProxyAcceptedAfterDrop(IProxyAcceptedAfterDropEvent event) {
				// TODO Auto-generated method stub
				
			}
		});
		
	}
	
	protected void init(){
		
		this.panel = new AbsolutePanel();
		this.panel.add(ico);
		this.panel.add(label);
		this.panel.setTitle(this.getDescription());
	
	}
	
	
	public HashSet<Class<? extends IUIElement>> getDraggedTypes() {
		
		HashSet<Class<? extends IUIElement>> types = new HashSet<Class<? extends IUIElement>>();
		
		types.add(this.getIUIElementType());
		
		return types;
	}
	
	public void setLabelVisible(boolean visible){
		this.label.setVisible(visible);
	}
	
	public void setSmallIcon(boolean b){
		if (b){
			this.ico.setUrl(GWT.getModuleBaseURL()+"/"+getSmallIcon());
		}else{
			this.ico.setUrl(GWT.getModuleBaseURL()+"/"+getBigIcon());
		}
	}
	
	protected abstract String getLabel();
	
	protected abstract String getDescription();
	
	protected abstract String getBigIcon();
	
	protected abstract String getSmallIcon();
	
	@Override
	public Widget getMainWidget() {
		
		if (panel==null){
			
			this.label = new Label(getLabel());
			this.label.addStyleName("float-left");
		
			this.ico   = new Image(GWT.getModuleBaseURL()+"/"+this.getBigIcon());
			this.ico.addStyleName("float-left");
			
			this.ico.addMouseMoveHandler(new MouseMoveHandler() {
				
				public void onMouseMove(MouseMoveEvent arg0) {
					
					arg0.preventDefault();
					
				}
			});
			this.ico.addMouseDownHandler(new MouseDownHandler() {
				
				public void onMouseDown(MouseDownEvent arg0) {
					
					arg0.preventDefault();
					
				}
			});
			
			init();
		}
		
		return panel;
	}
	
	public String getProxyImgUrl() {
		return getBigIcon();
	}
	
	@Override
	protected void onLoad() {
		super.onLoad();
		
		//panel.setWidgetPosition(label, this.ico.getOffsetWidth()+5, 9);
		
	}
	
}
