/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasybpmneditor.bpmndiagram.modeleditor.template;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.common.IBPMNElement;
import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramView;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.AbstractUITemplate;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

public abstract class AbstractTemplate extends AbstractUITemplate {
	
	private IBPMNElement bpmnElement;
	
	public AbstractTemplate(IBPMNElement bpmnElement) {
		
		this.bpmnElement = bpmnElement;
		this.bpmnElement.setFormTemplate(this);
		this.initMappingPolicies() ;
		
	}
	
	public AbstractTemplate() {
	
	}

	
	@Override
	public void refresh() {
		

		
	}
	
	public AbstractTemplate(IDiagramView bpmnDiagram) {
		// TODO Auto-generated constructor stub
	}

	@Override
	public Widget getTemplate() {
		
		VerticalPanel vp						 		= new VerticalPanel();
		
		vp.add(new Label(getTitle()));
		
		ArrayList<LabelWidgetPair> allLabelWidgetPair 	= new ArrayList<LabelWidgetPair>();

		
		
		allLabelWidgetPair.addAll(getPairs());

		
		Grid grid = new Grid(allLabelWidgetPair.size(),2);
		
		for(int i=0;i<=allLabelWidgetPair.size()-1;i++){
			
			LabelWidgetPair lwp = allLabelWidgetPair.get(i);
			
				grid.setWidget(i, 0, new Label(lwp.getLabel()));
				grid.setWidget(i, 1, lwp.getWidget());
			
		}
		
		vp.add(grid);
		
		return vp;
	}
	
	
	abstract protected List<LabelWidgetPair> getPairs();
	
	protected String getTitle(){
		return bpmnElement.getName();
	}
	
	
	protected class LabelWidgetPair{
		
		private String label;
		private Widget widget;
		
		public LabelWidgetPair(String label,Widget widget) {
			this.label = label;
			this.widget = widget;
		}
		
		public String getLabel() {
			return label;
		}
		
		public Widget getWidget() {
			return widget;
		}
	}
	
	protected void initMappingPolicies(){
		
	}
	
	public IBPMNElement getBpmnElement() {
		return bpmnElement;
	}
	
}
