/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasybpmneditor.bpmndiagram.modeleditor.template;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.common.IFlowNodeBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.infrastructure.IDefinitionsBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.process.gateway.ISequenceFlowBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.DefinitionsHelper;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.common.IBPMNElement;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.editormodels.CallActivityEditorModel;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.editormodels.TaskEditorModel;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.EnclosedFieldMappingPolicy;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.IInstantiationHandler;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.UIBindingManager;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.uifield.ListUIField;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.uifield.events.DisplayEvent;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.uifield.events.IUIFieldHandler;
import com.google.gwt.user.client.ui.Widget;

public class ActivityFormTemplate extends CommonFormTemplate {
	
	private List<ISequenceFlowBean> outgoingSequenceFlows;
	
	public ActivityFormTemplate(IBPMNElement bpmnElement) {
		super(bpmnElement);

	}

	@Override
	protected List<LabelWidgetPair> getPairs() {
		
		ArrayList<LabelWidgetPair> result = new ArrayList<LabelWidgetPair>();	
		
		result.addAll(super.getPairs());
		
		Widget defaultSequenceFlow = (Widget) this.getUIField("defaultSequenceFlow");
		
		if (defaultSequenceFlow!=null) result.add(new LabelWidgetPair("Default", defaultSequenceFlow));
		
		return result;
	}
	
	@Override
	protected void initMappingPolicies() {
		super.initMappingPolicies();
		
		IDefinitionsBean defs  = (IDefinitionsBean) getBpmnElement().getMainModel();
		this.outgoingSequenceFlows = DefinitionsHelper.getInstance().getOutgoingSequenceFlows((IFlowNodeBean) getBpmnElement().getDiagramElement().getModelElement(), defs);
		
		
		////////////Default Sequence Flow

		IInstantiationHandler<ListUIField<ISequenceFlowBean>> iHandler = new IInstantiationHandler<ListUIField<ISequenceFlowBean>>() {
			@Override
			public ListUIField<ISequenceFlowBean> instantiate() {
				
				final ListUIField<ISequenceFlowBean> seqFlowsList = new ListUIField<ISequenceFlowBean>(outgoingSequenceFlows);
				seqFlowsList.addUIFieldHandler(new IUIFieldHandler() {
					
					@Override
					public void onDisplay(DisplayEvent event) {

						seqFlowsList.setOptions(outgoingSequenceFlows);
						
					}
				});
				
				return seqFlowsList;
			}
			
		};
		
		//Task
		EnclosedFieldMappingPolicy efmp1 = new EnclosedFieldMappingPolicy(TaskEditorModel.class, "defaultSequenceFlow", iHandler);
		
		UIBindingManager.getInstance().addClassMappingPolicy(efmp1);
		
		//Call Activity
		EnclosedFieldMappingPolicy efmp2 = new EnclosedFieldMappingPolicy(CallActivityEditorModel.class, "defaultSequenceFlow", iHandler);
		
		UIBindingManager.getInstance().addClassMappingPolicy(efmp2);		
		
		
	}
	
	
	@Override
	public void refresh() {
		super.refresh();
		
		IDefinitionsBean defs  = (IDefinitionsBean) getBpmnElement().getMainModel();
		this.outgoingSequenceFlows = DefinitionsHelper.getInstance().getOutgoingSequenceFlows((IFlowNodeBean) getBpmnElement().getDiagramElement().getModelElement(), defs);

		
	}
	
	
}
